package ru.yandex.autotests.direct.web.pages;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Created by shmykov on 24.06.14.
 */
public class MordaPage extends BasePageObject {


    @Name("Кнопка 'Разместить рекламу' вверху страницы")
    @FindBy(xpath = ".//a[contains(@data-bem, '\"START_ADVERT\"')]")
    private Button placeAdHeadButton;

    @Name("Кнопка 'Разместить рекламу' внизу страницы")
    @FindBy(xpath = ".//a[contains(@data-bem, '\"START_ADVERT1\"')]")
    private Button placeAdBottomButton;

    @Name("Домик авторизации")
    @FindBy(css = ".auth_content_auto")
    private WebElement domik;


    public void clickOnPlaceAdHeadButton() {
        placeAdHeadButton.click();
    }

    public void clickOnPlaceAdBottomButton() {
        placeAdBottomButton.click();
    }


    public void checkPlaceAdHeadButton(Matcher<Button> matcher) {
        assertThat("состояние кнопки 'Разместить рекламу' не соответствует ожиданиям",
                placeAdHeadButton, matcher);
    }

    public void checkDomik(Matcher<WebElement> matcher) {
        assertThat("состояние домика авторизации не соответствует ожиданиям",
                domik, matcher);
    }

}
