package ru.yandex.autotests.direct.web.pages;

import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.SelectInputMethod;
import ru.yandex.autotests.direct.web.util.helpers.URLParameterHelper;
import ru.yandex.autotests.direct.web.webelements.SelectNanoIslands;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.passport.api.tools.captcha.CaptchaActions;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillSelect;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

/**
 * User: buhter
 * Date: 22.11.13
 * Time: 11:50
 */
@FindBy(xpath = "//body")
public class NewRegistrationPage extends HtmlElement {
    @Name("Поле ввода пароля")
    @FindBy(xpath = ".//input[@id='password']")
    private TextInput passwordInput;

    @Name("Поле подтверждения пароля")
    @FindBy(xpath = ".//input[@id='password_confirm']")
    private TextInput passwordConfirmInput;

    @Name("Переключение на воспрос для восстановления пароля")
    @FindBy(xpath = ".//a[contains(@class, 'set_question')]")
    private Link changeToQuestionLink;

    @Name("Выбор вопроса для восстановления пароля")
    @FindBy(xpath = ".//select[@name='hint_question_id']")
    private SelectNanoIslands hintQuestionSelect;

    @Name("Подсказка для воспроса")
    @FindBy(xpath = ".//input[@id='hint_answer']")
    private TextInput hintAnswerInput;

    @Name("Поле ввода капчи")
    @FindBy(xpath = ".//input[@id='answer']")
    private TextInput captchaInput;

    @Name("Капча")
    @FindBy(xpath = ".//img[@class='captcha__captcha__text']")
    private WebElement captchaElement;

    @Name("Кнопка регистрации")
    @FindBy(xpath = ".//button[@class='submit-button']")
    private Button submitButton;

    public TextInput getPasswordInput() {
        return passwordInput;
    }

    public TextInput getPasswordConfirmInput() {
        return passwordConfirmInput;
    }

    public Link getChangeToQuestionLink() {
        return changeToQuestionLink;
    }

    public SelectNanoIslands getHintQuestionSelect() {
        return hintQuestionSelect;
    }

    public TextInput getHintAnswerInput() {
        return hintAnswerInput;
    }

    public Button getSubmitButton() {
        return submitButton;
    }

    public void register(User user) {
        fillTextInput(getPasswordInput(), user.getPassword() + user.getPassword());
        fillTextInput(getPasswordConfirmInput(), user.getPassword() + user.getPassword());
        getChangeToQuestionLink().click();
        fillSelect(getHintQuestionSelect(), "3", SelectInputMethod.BY_VALUE);
        fillTextInput(getHintAnswerInput(), "100200" + Keys.ESCAPE);
        fillTextInput(captchaInput, CaptchaActions.getCaptchaAnswerByKey(URLParameterHelper.getUrlParameterByName(
                captchaElement.getAttribute("src"), "key")));
        getSubmitButton().click();
    }
}
