package ru.yandex.autotests.direct.web.pages;

import org.openqa.selenium.Cookie;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class PassportPage extends BasePageObject {

    @Name("login")
    @FindBy(name = "login")
    private TextInput login;

    @Name("pass")
    @FindBy(name = "passwd")
    private TextInput pass;

    @Name("enter")
    @FindBy(xpath = ".//*[@type = 'submit']")
    private Button enter;

    public void openPassport() {
        config.getDriver().get("https://passport.yandex.ru/passport");
    }

    public void login(String login, String password) {
        takeScreenshot();
        Cookie cookie = config.getDriver().manage().getCookieNamed("yandex_login");
        if (cookie != null) {
            if (login.equals(cookie.getValue())) {
                return;
            } else {
                logout();
                openPassport();
            }
        }
        fillTextInput(this.login, login);
        fillTextInput(pass, password);
        takeScreenshot();
        enter.click();
    }

    public void openPassportPageAndLogin(String login, String password) {
        openPassport();
        login(login, password);
    }

    public void logout() {
        String yandexuid = config.getDriver().manage().getCookieNamed("yandexuid").getValue();
        String logoutUrl =
                String.format(
                        "https://passport.yandex.ru/passport?mode=logout&yu=%s",
                        yandexuid);
        config.getDriver().get(logoutUrl);
    }
}
