package ru.yandex.autotests.direct.web.pages.account;


import java.util.List;
import java.util.concurrent.TimeUnit;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.strategy.objects.StrategyInfoWeb;
import ru.yandex.autotests.direct.web.objects.transfer.PayCampElement;
import ru.yandex.autotests.direct.web.objects.transfer.PaymentMoney;
import ru.yandex.autotests.direct.web.pages.campaigns.blocks.DayBudgetBlock;
import ru.yandex.autotests.direct.web.pages.clients.WalletLimitEditInfoWeb;
import ru.yandex.autotests.direct.web.webelements.bem.TumblerBEM;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;


import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.StringHelper.getNumericValueWithoutSpacesAndWords;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.timeoutHasExpired;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.isDisplayed;
import static ru.yandex.qatools.htmlelements.matchers.common.IsElementEnabledMatcher.isEnabled;

@NamedUrls({
        @NamedUrl(name = "client.wallet.page", url = "/registered/main.pl?cmd=clientWallet"),
        @NamedUrl(name = "clients.wallet.page.super", url = "/registered/main.pl?cmd=clientWallet&ulogin={1}"),
        @NamedUrl(name = "clients.wallet.page", url = "/registered/main.pl?cmd=clientWallet&AgencyID={2}&ulogin={1}")
})
public class ClientWalletPage extends BasePageObject {
    @Name("Кнопка доплатить")
    @FindBy(xpath = "(//div[contains(@class, 'b-client-wallet__col-act')]//button)[1]")
    private WebElement payButton;

    @Name("Тумблер общего счета")
    @FindBy(xpath = "//span[contains(@class, 'p-client-wallet__switcher')]//input")
    private TumblerBEM accountSwitcher;

    @Name("Кнопка подключения общего счета")
    @FindBy(xpath = "//button[contains(@class,'b-enable-wallet__button')]")
    private Button enableAccountButton;

    @Name("Остаток на общем счете")
    @FindBy(xpath = "//div[contains(@class, 'b-client-wallet__row-remain')]//div[contains(@class, 'b-client-wallet__col-val')]")
    private WebElement accountRest;

    @Name("Предупреждение о возможности включать общий счет не чаще чем раз в сутки")
    @FindBy(xpath = "//div[contains(@class, 'b-enable-wallet__frequency-warning')]/span/span")
    private WebElement accountFrequencyWarningText;

    @Name("Кнопка настройки дневного бюджета на общий счет")
    @FindBy(xpath = ".//div[contains(@class, 'b-client-wallet__row-daily-budget')]//button")
    private Button walletDayBudgetButton;

    @Name("Сумма дневного бюджета на ОС")
    @FindBy(xpath = ".//div[contains(@class, 'b-client-wallet__row-daily-budget')]//div[contains(@class, 'b-client-wallet__col-val')]")
    private WebElement walletDayBudgetSum;

    @Name("Кнопка настройки порога отключения на общий счёт")
    @FindBy(xpath = ".//div[@class='b-client-wallet__switch-off-limit-popup-opener-wrapper']//button")
    private WebElement openWalletLimitEditPopup;

    @Name("Хинт для не подключенного порога отключения")
    @FindBy(xpath = ".//div[contains(@class, 'b-client-wallet__switch-off-limit-hint-text')]")
    private WebElement hintWalletLimitEdit;

    private DisableAccountPopupBlock disableAccountPopupBlock;
    private PayPopupBlock payPopup;
    private PayPopupBlockNew payPopupNew;
    private DisableAccountDialog dialog;
    private DayBudgetBlock dayBudgetPopupBlock;
    private WalletLimitEditPopup walletLimitEditPopup;

    private WebElement getPayButton() {
        return payButton;
    }

    private TumblerBEM getAccountSwitcher() {
        return accountSwitcher;
    }

    private WebElement getAccountRest() {
        return accountRest;
    }

    private WebElement getAccountFrequencyWarningText() {
        return accountFrequencyWarningText;
    }

    private PayPopupBlock getPayPopup() {
        payPopup.setConfig(config);
        return payPopup;
    }

    private PayPopupBlockNew getPayPopupNew() {
        payPopupNew.setConfig(config);
        return payPopupNew;
    }

    public DayBudgetBlock getDayBudgetPopupBlock() {
        dayBudgetPopupBlock.setConfig(config);
        return dayBudgetPopupBlock;
    }

    public DisableAccountPopupBlock getDisableAccountPopupBlock() {
        return disableAccountPopupBlock;
    }

    public void openPayPopup() {
        getPayButton().click();
    }

    public void openDisablePopup() {
        accountSwitcher.deselect();
    }

    public void openWalletDayBudgetPopup() {
        walletDayBudgetButton.click();
    }

    public void acceptAlertIfPresent() {
        if (isDisplayed().matches(dialog)) {
            dialog.accept();
        }
    }

    public void clickEnableAccount() {
        enableAccountButton.click();
    }

    public void fillDisableForm(PaymentMoney paymentMoney) {
        getDisableAccountPopupBlock().selectCampaignsWithValues(paymentMoney.getPayCampElementList());
    }

    public void disableAccountShareEqual(List<Long> campaigns) {
        getDisableAccountPopupBlock().selectCampaigns(campaigns);
        getDisableAccountPopupBlock().shareEqual();
        disableAccount();
    }

    public void disableAccountShareEqual() {
        getDisableAccountPopupBlock().selectAll();
        getDisableAccountPopupBlock().shareEqual();
        disableAccount();
    }

    public void disableAccountShareProportion(List<Long> campaigns) {
        getDisableAccountPopupBlock().selectCampaigns(campaigns);
        getDisableAccountPopupBlock().shareProportion();
        disableAccount();
    }

    public void disableAccountShareProportion() {
        getDisableAccountPopupBlock().selectAll();
        getDisableAccountPopupBlock().shareProportion();
        disableAccount();
    }

    @Step("Жмем кнопку выключения общего счета")
    public void disableAccount() {
        takeScreenshot();
        getDisableAccountPopupBlock().checkDisableAccountButton(should(isEnabled())
                .whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(5))));
        getDisableAccountPopupBlock().disable();
    }

    public void disableAccount(List<PayCampElement> campElementList) {
        getDisableAccountPopupBlock().selectCampaignsWithValues(campElementList);
        disableAccount();
    }

    public void checkRest(Matcher<WebElement> matcher) {
        assertThat("неверное значение общего счета", getAccountRest(), matcher);
    }

    public void checkAccountFrequencyWarning(Matcher<WebElement> matcher) {
        assertThat("ошибка в предупреждении об частоте продключения общего счета", getAccountFrequencyWarningText()
                , matcher);
    }

    public void checkEnableButton(Matcher<WebElement> matcher) {
        assertThat("неверное состояние кнопки включения общего счета", enableAccountButton.getWrappedElement()
                , matcher);
    }

    public void checkDisableButton(Matcher<WebElement> matcher) {

        assertThat("неверное состояние кнопки отключения общего счета", getAccountSwitcher().getWrappedElement()
                , matcher);
    }

    public void pay(float sum) {
        openPayPopup();
        getPayPopup().pay(sum);
    }

    public void payWithCash() {
        openPayPopup();
        getPayPopup().payWithCash();
    }

    public void payWithNewForm(float sum, PayMethodsEnum paymentType) {
        openPayPopup();
        waitForElement(getPayPopupNew(), 2, WebElementMatchers.isDisplayed());
        getPayPopupNew().pay(sum, paymentType);
    }

    public String getCashPaymentCode() {
        return getPayPopupNew().getCashPaymentCode();
    }

    public DisableAccountDialog getDialog() {
        return dialog;
    }

    public void fillWalletDayBudgetParameters(StrategyInfoWeb bean) {
        getDayBudgetPopupBlock().fillParametersAndSave(bean);
    }

    public void checkWalletDayBudget(Matcher matcher) {
        assertThat("значение дневного бюджета соответствует ожидаемому",
                getNumericValueWithoutSpacesAndWords(getWalletDayBudgetSum().getText()), matcher);
    }

    public WebElement getWalletDayBudgetSum() {
        return walletDayBudgetSum;
    }

    public void openWalletLimitEditPopup() {
        openWalletLimitEditPopup.click();
    }

    public WalletLimitEditPopup onWalletLimitEditPopup() {
        walletLimitEditPopup.setConfig(config);
        return walletLimitEditPopup;
    }

    public void switchOnWalletLimitEdit() {
        onWalletLimitEditPopup().switchOnWalletLimitEdit();
    }

    public void switchOffWalletLimitEdit() {
        onWalletLimitEditPopup().switchOffWalletLimitEdit();
    }

    public void fillWalletLimitEditParameters(WalletLimitEditInfoWeb autooverdraftParam) {
        onWalletLimitEditPopup().fillWalletLimitEditParameters(autooverdraftParam);
    }

    public void checkTextWalletLimitEdit(Matcher matcher) {
        assertThat("Блок порога отключения соответствует ожидаемому", hintWalletLimitEdit, matcher);
    }

    public WalletLimitEditInfoWeb getUncheckedLimitEditParameters(Boolean stateValues) {
        return onWalletLimitEditPopup().getValuesLimitEdit(stateValues);
    }

    public WalletLimitEditInfoWeb getCheckedLimitEditParameters(Boolean stateValues) {
        return onWalletLimitEditPopup().getValuesLimitEdit(stateValues);
    }

    public WalletLimitEditPopup getLimitEditPopupBlock() {
        walletLimitEditPopup.setConfig(config);
        return walletLimitEditPopup;
    }
}