package ru.yandex.autotests.direct.web.pages.account;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@FindBy(xpath = "//div[contains(@class, 'b-user-dialog__content')]")
public class DisableAccountDialog extends HtmlElement {

    @Name("Кнопка 'Ок'")
    @FindBy(xpath = ".//button[contains(@class, 'b-user-dialog__confirm')]")
    private Button okButton;

    @Name("Текст диалога")
    @FindBy(xpath = ".//div[contains(@class, 'b-user-dialog__body')]")
    private WebElement message;

    public void accept() {
        okButton.click();
    }

    public void checkMessage(Matcher<String> matcher) {
        assertThat("сообщение соответствует ожидаемому", message.getText(), matcher);
    }
}
