package ru.yandex.autotests.direct.web.pages.account;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.objects.transfer.PayCampElement;
import ru.yandex.autotests.direct.web.webelements.NumericInput;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import java.util.List;
import java.util.regex.Pattern;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@FindBy(css = "div.b-disconnect-wallet__popup")
public class DisableAccountPopupBlock extends HtmlElement {
    //region Fields
    @Name("Выбрать все")
    @FindBy(css = "div.b-checkboxes-group__cbx-all input")
    private CheckBox checkAll;

    @Name("Кнопка выключения общего счета")
    @FindBy(xpath = ".//button[contains(@class,'b-disconnect-wallet__submit')]")
    private Button disableAccountButton;

    @Name("Чекбокс 'Выбрать все'")
    @FindBy(xpath = ".//tr[@class='b-money-transfer__tr']/th/span[contains(@class, 'checkbox')]//input")
    private CheckBoxBEM selectAllCheckbox;

    @Name("Осталось перенести")
    @FindBy(xpath = ".//div[contains(@class, 'b-money-transfer__rest')]")
    private WebElement accountTransferRest;

    @Name("Линк 'Распределить поровну'")
    @FindBy(xpath = ".//span[contains(@class, 'b-money-transfer__equal')]")
    private WebElement shareEqualLink;

    @Name("Линк 'Распределить поровну'")
    @FindBy(xpath = ".//span[contains(@class, 'b-money-transfer__proportion')]")
    private WebElement shareProportionLink;

    private List<CampaignRow> campaigns;

    @FindBy(xpath = ".//tr[contains(@class, 'b-money-transfer__campaign')]")
    public class CampaignRow extends HtmlElement {
        //region Fields
        @Name("Чекбокс выбора кампании")
        @FindBy(xpath = ".//td/span[contains(@class, 'checkbox')]")
        private CheckBoxBEM checkbox;

        @Name("Сумма к переносу")
        @FindBy(xpath = ".//td/span[contains(@class, 'input')]//input")
        private NumericInput campaignTransferSum;

        @Name("Номер кампании")
        @FindBy(xpath = ".//div[@class='b-money-transfer__campaign-num']")
        private WebElement campaignID;
        //endregion

        //region Field getters
        private WebElement getCampaignID() {
            return campaignID;
        }

        private CheckBoxBEM getCheckbox() {
            return checkbox;
        }

        private NumericInput getCampaignTransferSum() {
            return campaignTransferSum;
        }
        //endregion

        public Long getCampaignIdValue() {
            String textValue = getCampaignID().getText();
            java.util.regex.Matcher matcher = Pattern.compile("\\d+").matcher(textValue);
            matcher.find(0);
            return Long.valueOf(textValue.substring(matcher.start(), matcher.end()));
        }
    }
    //endregion

    //region Field getters
    private CheckBox getCheckAll() {
        return checkAll;
    }

    private WebElement getAccountTransferRest() {
        return accountTransferRest;
    }

    private List<CampaignRow> getCampaigns() {
        return campaigns;
    }

    private CampaignRow getCampaign(Long campaignId) {
        List<CampaignRow> campaignsList = getCampaigns();
        for (CampaignRow campaign : campaignsList) {
            if (campaign.getCampaignIdValue().equals(campaignId)) {
                return campaign;
            }
        }
        return null;
    }

    private Button getDisableAccountButton() {
        return disableAccountButton;
    }

    private CheckBox getSelectAllCheckbox() {
        return selectAllCheckbox;
    }

    private WebElement getShareEqualLink() {
        return shareEqualLink;
    }

    private WebElement getShareProportionLink() {
        return shareProportionLink;
    }

    //endregion

    //region Actions
    public void selectAll() {
        getSelectAllCheckbox().select();
    }

    public void shareEqual() {
        getShareEqualLink().click();
    }

    public void shareProportion() {
        getShareProportionLink().click();
    }

    public void disable() {
        getDisableAccountButton().click();

    }

    public void selectCampaignsWithValues(List<PayCampElement> campaigns) {
        for (PayCampElement campaign : campaigns) {
            CampaignRow campaignRow = getCampaign(campaign.getCampaignId());
            campaignRow.getCheckbox().select();
            campaignRow.getCampaignTransferSum().setValue(campaign.getSum());
        }
    }

    public void selectCampaigns(List<Long> campaigns) {
        for (Long campaign : campaigns) {
            getCampaign(campaign).getCheckbox().select();
        }
    }

    //endregion

    //region Assertion
    public void checkDisableAccountButton(Matcher<WebElement> matcher) {
        assertThat("состояние кнопки отключения счета отличается от ожидаемого"
                , getDisableAccountButton().getWrappedElement(), matcher);
    }

    public void checkTransferRest(Matcher<WebElement> matcher) {
        assertThat("остаток для переноса отличается от ожидаемого", getAccountTransferRest(), matcher);
    }
    //endregion
}
