package ru.yandex.autotests.direct.web.pages.account;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.WebElementsActions;
import ru.yandex.autotests.direct.web.webelements.NumericInput;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.Link;
import ru.yandex.qatools.htmlelements.element.TextInput;

@Name("Попап пополнения общего счета")
@FindBy(css = "div.b-pay__content")
public class PayPopupBlock extends ExtendedHtmlElement {
    //region Fields
    @Name("Сумма к оплате")
    @FindBy(xpath = ".//div[contains(@class, 'b-pay__sum')]//input")
    private NumericInput paySumInput;

    @Name("Кнопка 'Выписать счет'")
    @FindBy(css = "button.b-pay__submit")
    private Button submitPayButton;

    @Name("Ссылка на оплату наличными")
    @FindBy(css = "div.b-pay__form-buttons a")
    private Link payWithCashLink;

    private TextInput getPaySumInput() {
        return paySumInput;
    }

    private Button getSubmitPayButton() {
        return submitPayButton;
    }

    private Link getPayWithCashLink() {
        return payWithCashLink;
    }

    public void pay(float payValue) {
        new WebElementsActions(config).fillTextInputWithClickAndEvents(getPaySumInput(), String.valueOf(payValue));
        takeScreenshot();
        getSubmitPayButton().click();
    }

    public void payWithCash() {
        getPayWithCashLink().click();
    }
}
