package ru.yandex.autotests.direct.web.pages.account;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.pages.clients.SelectNew;
import ru.yandex.autotests.direct.web.util.WebElementsActions;
import ru.yandex.autotests.direct.web.webelements.NumericInput;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;

@Name("Новый попап пополнения общего счета")
@FindBy(css = "div.b-pay__content")
public class PayPopupBlockNew extends ExtendedHtmlElement {

    @Name("Спинер загрузки")
    @FindBy(xpath = ".//div[contains(@class,'spin2_progress_yes')]")
    private WebElement spiner;

    @Name("Сумма к оплате")
    @FindBy(css = ".b-pay__sum-without-nds input")
    private NumericInput paySumInput;

    @Name("Селект выбора способа оплаты")
    @FindBy(xpath = ".//span[contains(@class,'b-pay__payment-method-select')]//button")
    private SelectNew payMethodSelect;

    @Name("Код оплаты наличными")
    @FindBy(xpath = ".//div[@class='b-pay__payment-code']")
    private WebElement cashPaymentCode;

    @Name("Кнопка 'Выписать счет'")
    @FindBy(css = "button.b-pay__submit")
    private Button submitPayButton;

    private TextInput getPaySumInput() {
        return paySumInput;
    }

    private SelectNew getPayMethodSelect() {
        return payMethodSelect;
    }

    private Button getSubmitPayButton() {
        return submitPayButton;
    }

    public void pay(float payValue, PayMethodsEnum paymentType) {
        waitForElement(spiner, 5, not(WebElementMatchers.isDisplayed()));
        getPayMethodSelect().selectByVisibleText(paymentType.getValue());
        waitForElement(getPaySumInput().getWrappedElement(), 2, WebElementMatchers.isDisplayed());
        new WebElementsActions(config).fillTextInputWithClickAndEvents(getPaySumInput(), String.valueOf(payValue));
        takeScreenshot();
        if (getSubmitPayButton().isDisplayed()) {
            getSubmitPayButton().click();
        }
    }

    public String getCashPaymentCode() {
        return cashPaymentCode.getText().replace(" ", "");
    }
}
