package ru.yandex.autotests.direct.web.pages.account;


import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.pages.clients.DnaPageSelect;
import ru.yandex.autotests.direct.web.pages.clients.WalletLimitEditInfoWeb;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import java.util.List;
import java.util.function.Predicate;

import static com.google.common.base.Strings.isNullOrEmpty;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.*;


@Name("Попап настройки порога отключения на общий счет")
@FindBy(xpath = ".//div[contains(@class, 'modal_visible_yes') and //div[contains(@class, 'wallet-switch-off-limit-edit-popup')]]")
public class WalletLimitEditPopup extends ExtendedHtmlElement {

    @Name("Сумма порога отключения")
    @FindBy(xpath = ".//input[@class = 'Textinput-Control']")
    private TextInput sumInput;

    @Name("Подключить")
    @FindBy(xpath = ".//div[contains(@class, 'wallet-switch-off-limit-edit-popup__btn')]//button[@type = 'submit']")
    private Button buttonSwitchOn;

    @Name("Отключить")
    @FindBy(xpath = ".//div[contains(@class, 'wallet-switch-off-limit-edit-popup__reset-btn')]//button")
    private Button buttonSwitchOff;

    @Name("Список плательщиков")
    @FindBy(xpath = "(//div[contains(@class, 'wallet-switch-off-limit-edit-popup__ctrl')]//button)[1]")
    private DnaPageSelect listPerson;

    @Name("Список способов оплаты")
    @FindBy(xpath = "(//button[contains(@class, 'select2__button')])[2]")
    private DnaPageSelect listMethodPay;

    @Name("Заголовок попапа")
    @FindBy(xpath = ".//div[contains(@class, 'modal-decorator__title')]")
    private WebElement title;

    private WalletLimitEditInfoWeb result = new WalletLimitEditInfoWeb();

    private Predicate<WebElement> predicate;


    public void switchOnWalletLimitEdit() {
        buttonSwitchOn.click();
    }

    public void switchOffWalletLimitEdit() {
        buttonSwitchOff.click();
    }

    private TextInput getSumInput() {
        return sumInput;
    }

    public List<WebElement> getPersonList() {
        return listPerson.getOptions();
    }

    public List<WebElement> getMethodPayList() {
        return listMethodPay.getOptions();
    }

    public String getOptionText(List<WebElement> listOptions, Predicate<WebElement> predicate) {
        return listOptions
                .stream()
                .filter(predicate)
                .findFirst().orElseThrow(() -> new DirectWebError("Не найдено значение в селекте, удовлетворяющее условию"))
                .getText();
    }

    private void selectPersonParameters(String person) {
        if (!isNullOrEmpty(person)) {
            listPerson.selectByVisibleText(person);
        }
    }

    private void selectMethodPay(String methodPay) {
        if (!isNullOrEmpty(methodPay)) {
            listMethodPay.selectByVisibleText(methodPay);
        }
    }

    public void fillWalletLimitEditParameters(WalletLimitEditInfoWeb autooverdraftParam) {
        selectPersonParameters(autooverdraftParam.getPerson());
        selectMethodPay(autooverdraftParam.getMethodPay());
        getSumInput().clear();
        getSumInput().sendKeys(" ");
        fillTextInput(getSumInput(), autooverdraftParam.getPrice().toString());
    }

    public WalletLimitEditInfoWeb getValuesLimitEdit(Boolean stateValues) {
        if (stateValues) {
            predicate = option -> option.findElement(By.xpath(".//parent::div")).getAttribute("class").contains("menu__item_checked_yes");
        }
        else {
            predicate = option -> !option.findElement(By.xpath(".//parent::div")).getAttribute("class").contains("menu__item_checked_yes");
        }
        result = getLimitEditParameters(predicate);
        return result;
    }

    public WalletLimitEditInfoWeb getLimitEditParameters(Predicate<WebElement> predicate) {
        result.setPerson(getOptionText(getPersonList(), predicate));
        title.click();
        result.setMethodPay(getOptionText(getMethodPayList(), predicate));
        title.click();
        result.setPrice(Float.valueOf(getSumInput().getText().replace(",", ".").replace(" ", "")));
        return result;
    }
}