package ru.yandex.autotests.direct.web.pages.adjustment.blocks;

import java.util.List;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.adjustment.rates.AdjustmentTabsResources;
import ru.yandex.autotests.direct.web.objects.adjustment.rates.*;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by aleran on 13.08.2015.
 */
@Name("Попап корректировки ставок")
@FindBy(xpath = "//div[contains(@class, 'popup_visibility_visible') and contains(@class, 'b-adjustment-rates')]")
public class AdjustmentRatesPopupBlock extends HtmlElement implements IWebFrom<HierarchicalMultipliersWeb> {

    @Name("Вкладка корректировки")
    @FindBy(xpath = ".//li[contains(@class, 'tabs-menu__tab')]")
    private List<WebElement> tabs;

    @Name("Текущая вкладка")
    @FindBy(css = ".tabs-menu__tab_active_yes")
    private WebElement currentTab;

    private MobileMultiplierBlock mobileMultiplierBlock;

    private MobileByDeviceMultiplierBlock mobileByDeviceMultiplierBlock;

    private VideoMultiplierBlock videoMultiplierBlock;

    private RetargetingMultiplierBlock retargetingMultiplierBlock;

    private DemographyMultiplierBlock demographyMultiplierBlock;

    private InvetoryMultiplierBlock invetoryMultiplierBlock;


    @Name("Кнопка 'Сохранить'")
    @FindBy(css = "button.b-adjustment-rates-popup__apply")
    private Button saveButton;

    @Name("Кнопка 'Отмена'")
    @FindBy(css = "button.b-adjustment-rates-popup__decline")
    private Button cancelButton;

    public void setCurrentTab(AdjustmentTabsResources tabText) {
        WebElement expectedTab =
                tabs.stream().filter(t -> t.getText().equals(tabText.toString())).findFirst().orElse(null);
        if (expectedTab == null) {
            throw new DirectWebError("Cannot find tab with " + tabText);
        } else {
            expectedTab.click();
        }
    }

    public void clickCancel() {
        cancelButton.click();
    }

    public MobileMultiplierWeb getMobileMultiplierWeb(HierarchicalMultipliersWeb expectedBean) {
        if (expectedBean.getMobileMultiplierWeb().getDeviceType()==null)
        {
            setCurrentTab(AdjustmentTabsResources.MOBILE);
            return mobileMultiplierBlock.getMobileMultiplierWeb();
        }
        else {
            setCurrentTab(AdjustmentTabsResources.DEVICE);
            return mobileByDeviceMultiplierBlock.getMobileMultiplierWeb();
        }
    }

    public VideoMultiplierWeb getVideoMultiplierWeb() {
        setCurrentTab(AdjustmentTabsResources.VIDEO);
        return videoMultiplierBlock.getVideoMultiplierWeb();
    }

    public RetargetingMultiplierWeb getRetargetingMultiplierWeb() {
        setCurrentTab(AdjustmentTabsResources.RETARGETING);
        return retargetingMultiplierBlock.getRetargetingMultiplier();
    }

    public DemographyMultiplierWeb getDemographyMultiplierWeb() {
        setCurrentTab(AdjustmentTabsResources.DEMOGRAPHY);
        return demographyMultiplierBlock.getDemographyMultiplier();
    }

    public InventoryMultiplierWeb getInventoryMultiplierWeb() {
        setCurrentTab(AdjustmentTabsResources.INVENTORY);
        return invetoryMultiplierBlock.getInventoryMultiplier();
    }

    public HierarchicalMultipliersWeb getHierarchicalMultipliersWeb(HierarchicalMultipliersWeb hierarchicalMultipliersWeb) {
        return new HierarchicalMultipliersWeb()
                .withMobileMultiplier(getMobileMultiplierWeb(hierarchicalMultipliersWeb))
                .withVideoMultiplier(getVideoMultiplierWeb())
                .withRetargetingMultiplier(getRetargetingMultiplierWeb())
                .withDemographyMultiplier(getDemographyMultiplierWeb());
    }

    public void fillRetargetingMultiplier(RetargetingMultiplierWeb retargetingMultiplier) {
        if (retargetingMultiplier == null) {
            return;
        }
        setCurrentTab(AdjustmentTabsResources.RETARGETING);
        retargetingMultiplierBlock.fillRetargetingMultiplier(retargetingMultiplier);
    }

    public void fillMobileMultiplier(MobileMultiplierWeb mobileMultiplierWeb) {
        if (mobileMultiplierWeb == null) {
            return;
        }
        if (mobileMultiplierWeb.getDeviceType()==null) {
            setCurrentTab(AdjustmentTabsResources.MOBILE);
            mobileMultiplierBlock.fillMobileMultiplier(mobileMultiplierWeb);
        }
        else {
            setCurrentTab(AdjustmentTabsResources.DEVICE);
            mobileByDeviceMultiplierBlock.fillMobileMultiplier(mobileMultiplierWeb);
        }
    }

    public void fillVideoMultiplier(VideoMultiplierWeb videoMultiplierWeb) {
        if (videoMultiplierWeb == null) {
            return;
        }
        setCurrentTab(AdjustmentTabsResources.VIDEO);
        videoMultiplierBlock.fillVideoMultiplier(videoMultiplierWeb);
    }

    public void fillDemographyMultiplier(DemographyMultiplierWeb demographyMultiplier) {
        if (demographyMultiplier == null) {
            return;
        }
        setCurrentTab(AdjustmentTabsResources.DEMOGRAPHY);
        demographyMultiplierBlock.fillDemographyMultiplier(demographyMultiplier);
    }

    public void fillInventoryMultiplier(InventoryMultiplierWeb inventoryMultiplier) {
        if (inventoryMultiplier == null) {
            return;
        }
        setCurrentTab(AdjustmentTabsResources.INVENTORY);
        invetoryMultiplierBlock.fillInventoryMultiplier(inventoryMultiplier);
    }


    @Override
    public void fillParameters(HierarchicalMultipliersWeb hierarchicalMultipliers) {
        fillRetargetingMultiplier(hierarchicalMultipliers.getRetargetingMultiplierWeb());
        fillMobileMultiplier(hierarchicalMultipliers.getMobileMultiplierWeb());
        fillVideoMultiplier(hierarchicalMultipliers.getVideoMultiplierWeb());
        fillDemographyMultiplier(hierarchicalMultipliers.getDemographyMultiplierWeb());
        fillInventoryMultiplier(hierarchicalMultipliers.getInventoryMultiplierWeb());
        saveButton.click();
    }

    @Override
    public void checkParameters(HierarchicalMultipliersWeb hierarchicalMultipliers) {
        assertThat("неверные параметры корректировки ставок", getFormFieldsAccording(hierarchicalMultipliers),
                beanDiffer(hierarchicalMultipliers));
    }

    @Override
    public HierarchicalMultipliersWeb getFormFieldsAccording(HierarchicalMultipliersWeb expectedBean) {
        return inAccordanceWith(expectedBean).forNew(HierarchicalMultipliersWeb.class)
                .set("mobileMultiplierWeb", this, on(AdjustmentRatesPopupBlock.class).getMobileMultiplierWeb(expectedBean))
                .set("videoMultiplierWeb", this, on(AdjustmentRatesPopupBlock.class).getVideoMultiplierWeb())
                .set("demographyMultiplierWeb", this, on(AdjustmentRatesPopupBlock.class).getDemographyMultiplierWeb())
                .set("retargetingMultiplierWeb", this,
                        on(AdjustmentRatesPopupBlock.class).getRetargetingMultiplierWeb())
                .set("inventoryMultiplierWeb", this, on(AdjustmentRatesPopupBlock.class).getInventoryMultiplierWeb())
                .getActualBean();
    }
}
