package ru.yandex.autotests.direct.web.pages.adjustment.blocks;

import java.util.List;
import java.util.stream.Collectors;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.adjustment.rates.DemographyConditionWeb;
import ru.yandex.autotests.direct.web.objects.adjustment.rates.DemographyMultiplierWeb;
import ru.yandex.autotests.direct.web.pages.adjustment.blocks.conditions.DemographyMultiplierConditionBlock;
import ru.yandex.autotests.direct.web.webelements.bem.TumblerBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * Created by aleran on 13.08.2015.
 */
@Name("Корректировки ставок по полу и возрасту")
@FindBy(css = ".b-adjustment-rates_type_demography")
public class DemographyMultiplierBlock extends HtmlElement {

    @Name("Список условий")
    @FindBy(css = ".b-adjustment-rates__list li")
    private List<DemographyMultiplierConditionBlock> conditionsBlock;

    @Name("Тумблер 'Вкл/Откл'")
    @FindBy(xpath = ".//span[contains(@class, '-adjustment-rates__tumbler')]//input")
    private TumblerBEM isEnabled;

    @Name("Добавить корректировку")
    @FindBy(css = ".b-adjustment-rates__add-rate")
    private Button addCondition;

    public DemographyMultiplierWeb getDemographyMultiplier(){
        List<DemographyConditionWeb> conds = conditionsBlock.stream()
                .map(DemographyMultiplierConditionBlock::getDemographyConditionWeb).collect(Collectors.toList());
        return new DemographyMultiplierWeb()
                .withConditions(conds)
                .withEnabled(isEnabled.isSelected() ? 1 : 0);
    }

    public void fillDemographyMultiplier(DemographyMultiplierWeb demographyMultiplier){

        for (DemographyConditionWeb cond : demographyMultiplier.getConditions()){
            addCondition.click();
            DemographyMultiplierConditionBlock lastCondition = conditionsBlock.get(conditionsBlock.size()-1);
            lastCondition.fillDemographyCondition(cond);
        }

        if (demographyMultiplier.getEnabled() == 1) {
            isEnabled.select();
        } else if (demographyMultiplier.getEnabled() == 0) {
            isEnabled.deselect();
        }
    }
}
