package ru.yandex.autotests.direct.web.pages.adjustment.blocks;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.objects.adjustment.rates.MobileMultiplierWeb;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;

import java.util.List;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

@Name("Попап корректировки ставок по устройствам")
@FindBy(css = ".b-adjustment-rates_type_devices")
public class MobileByDeviceMultiplierBlock extends HtmlElement {

    @Name("Направление")
    @FindBy(css = "span.b-adjustment-rates__select select")
    private SelectBEM mobilePctTypeSelect;

    @Name("Умножать на")
    @FindBy(xpath = "(.//span[contains(@class, 'b-adjustment-rates__input')]//input)[2]")
    private TextInput mobilePctTextInput;

    @Name("Добавить корректировку")
    @FindBy(xpath = ".//button[contains(@class, 'b-adjustment-rates__add-rate')]")
    private Button addAdjustmentRates;

    @Name("Список устройств")
    @FindBy(xpath = "//div[@class = 'b-adjustment-device-chooser__content']//div[contains(@class, 'menu__item')]")
    private List<WebElement> deviceList;

    @Name("Добавить условие")
    @FindBy(xpath = "//button[contains(@class, 'b-adjustment-device-chooser__add-button')]")
    private Button addDevice;

    @Name("Тип устройства")
    @FindBy(xpath = ".//button[contains(@class, 'b-adjustment-rates__button')]//div")
    private WebElement deviceType;

    public MobileMultiplierWeb getMobileMultiplierWeb(){
        return new MobileMultiplierWeb()
                .withDeviceType(deviceType.getText())
                .withMultiplierPct(mobilePctTextInput.getText());
    }

    public void fillMobileMultiplier(MobileMultiplierWeb mobileMultiplier){
        if (mobileMultiplier.getDeviceType()!=null) {
            addDevice(mobileMultiplier);
        }
        fillTextInput(mobilePctTextInput, mobileMultiplier.getMultiplierPct());
    }

    public void selectDeviceTypeByText(String deviceName) {
        deviceList
                .stream()
                .filter(x -> x.getText().equals(deviceName))
                .findFirst()
                .orElseThrow(() -> new DirectWebError("Не найдено значение в селекте, удовлетворяющее условию"))
                .findElement(By.xpath(".//label"))
                .click();
    }

    public void addDevice(MobileMultiplierWeb mobileMultiplier) {
        addAdjustmentRates.click();
        selectDeviceTypeByText(mobileMultiplier.getDeviceType());
        addDevice.click();
    }
}