package ru.yandex.autotests.direct.web.pages.adjustment.blocks;

import java.util.List;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.adjustment.rates.MobileMultiplierWeb;
import ru.yandex.autotests.direct.web.pages.adjustment.blocks.conditions.DemographyMultiplierConditionBlock;
import ru.yandex.autotests.direct.web.pages.adjustment.blocks.conditions.DevicesConditionBlock;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

@Name("Попап корректировки ставок")
@FindBy(css = ".b-adjustment-rates_type_devices")
public class MobileMultiplierBlock extends HtmlElement {

    @Name("Новая корректировка")
    @FindBy(css = ".b-adjustment-rates__add-rate")
    private Button newCorrection;

    @Name("Виды смартфонов")
    @FindBy(xpath = "//div[contains(@class, 'b-adjustment-device-chooser__content')]//input")
    private RadioBEM smartphonesTypes;

    @Name("Добавить корректировку")
    @FindBy(xpath = "//button[contains(@class, 'b-adjustment-device-chooser__add-button')]")
    private Button addMobileType;

    @Name("Список условий")
    @FindBy(css = ".b-adjustment-rates__list li")
    private List<DevicesConditionBlock> conditionsBlock;

    public MobileMultiplierWeb getMobileMultiplierWeb(){
        return conditionsBlock.get(0).getMobileMultiplierWeb();
    }

    public void fillMobileMultiplier(MobileMultiplierWeb mobileMultiplier){
        newCorrection.click();
        smartphonesTypes.selectByValue("all_mobile");
        addMobileType.click();
        conditionsBlock.get(0).fillDemographyCondition(mobileMultiplier);
    }
}
