package ru.yandex.autotests.direct.web.pages.adjustment.blocks;

import java.util.HashMap;
import java.util.List;

import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.adjustment.rates.RetargetingConditionWeb;
import ru.yandex.autotests.direct.web.objects.adjustment.rates.RetargetingMultiplierWeb;
import ru.yandex.autotests.direct.web.pages.adjustment.blocks.conditions.RetargetingMultiplierConditionBlock;
import ru.yandex.autotests.direct.web.webelements.bem.TumblerBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * Created by aleran on 13.08.2015.
 */
@Name("Корректировки ставок для посетивших сайт")
@FindBy(css = ".b-adjustment-rates_type_retargeting")
public class RetargetingMultiplierBlock extends HtmlElement {

    @Name("Список условий")
    @FindBy(css = ".b-adjustment-rates__list li")
    private List<RetargetingMultiplierConditionBlock> conditionsBlock;

    @Name("Список условий ретаргетинга")
    @FindBy(xpath = "./ancestor::div[contains(@class, 'b-adjustment-rates-popup')]" +
            "//div[contains(@class,'b-adjustment-rates-popup-chooser__chooser-item')]")
    private List<WebElement> retargetingsBlock;

    @Name("Добавить условие ретаргетинга")
    @FindBy(xpath = "./ancestor::div[contains(@class, 'b-adjustment-rates-popup')]" +
            "//button[contains(@class,'b-adjustment-rates-popup-chooser__add')]")
    private WebElement addRetargeting;

    @Name("Тумблер 'Вкл/Откл'")
    @FindBy(xpath = ".//span[contains(@class, '-adjustment-rates__tumbler')]//input")
    private TumblerBEM isEnabled;

    @Name("Добавить корректировку")
    @FindBy(css = ".b-adjustment-rates__add-rate")
    private Button addCondition;

    public WebElement getRetargetingById(String id){
        for (WebElement retargeting : retargetingsBlock){
            if (retargeting.getAttribute("data-bem").contains("\"retargetingId\":\""+id+"\"")){
                return retargeting;
            }
        }
        throw new NoSuchElementException("No retargeting choose");
    }

    public String getRetargetingIdByName(String name){
        for (WebElement retargeting : retargetingsBlock){
            if (retargeting.getAttribute("data-bem").contains("\"name\":\""+name+"\"")){
                return retargeting.getAttribute("data-bem").replaceFirst(".*\"retargetingId\":\"(\\d+)\".*","$1");
            }
        }
        throw new NoSuchElementException("No retargeting choose");
    }

    public void addRetargeting(String id){
        addCondition.click();
        getRetargetingById(id).click();
        addRetargeting.click();
    }

    public RetargetingMultiplierWeb getRetargetingMultiplier(){
        HashMap<String,RetargetingConditionWeb> conditionMap = new HashMap<>();
        for (RetargetingMultiplierConditionBlock conditionBlock : conditionsBlock){
            conditionBlock.clickRetargetingButton();
            conditionMap.put(
                    getRetargetingIdByName(conditionBlock.getRetargetingName()),
                    conditionBlock.getRetargetingConditionWeb());
        }
        return new RetargetingMultiplierWeb()
                .withConditions(conditionMap)
                .withEnabled(isEnabled.isSelected() ? 1 : 0);
    }

    public void fillRetargetingMultiplier(RetargetingMultiplierWeb retargetingMultiplier){
        for (String conditionKey : retargetingMultiplier.getConditions().keySet()){
            addRetargeting(conditionKey);
            RetargetingMultiplierConditionBlock lastCondition = conditionsBlock.get(conditionsBlock.size()-1);
            lastCondition.fillRetargetingCondition(retargetingMultiplier.getConditions().get(conditionKey));
        }

        if (retargetingMultiplier.getEnabled() == 1) {
            isEnabled.select();
        } else if (retargetingMultiplier.getEnabled() == 0) {
            isEnabled.deselect();
        }
    }
}
