package ru.yandex.autotests.direct.web.pages.adjustment.blocks;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.adjustment.rates.VideoMultiplierWeb;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

@Name("Попап корректировки ставок")
@FindBy(css = ".b-adjustment-rates_type_video")
public class VideoMultiplierBlock extends HtmlElement {
    @Name("Направление")
    @FindBy(css = "span.b-adjustment-rates__select select")
    private SelectBEM videoPctTypeSelect;

    @Name("Умножать на")
    @FindBy(css = "span.b-adjustment-rates__input input")
    private TextInput videoPctTextInput;

    public VideoMultiplierWeb getVideoMultiplierWeb() {
        return new VideoMultiplierWeb().withMultiplierPct(videoPctTextInput.getText());
    }

    public void fillVideoMultiplier(VideoMultiplierWeb videoMultiplier) {
        fillTextInput(videoPctTextInput, videoMultiplier.getMultiplierPct());
    }
}
