package ru.yandex.autotests.direct.web.pages.adjustment.blocks.conditions;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.adjustment.rates.DemographyConditionWeb;
import ru.yandex.autotests.direct.web.webelements.bem.HierarchicalMultipliersRadioBEM;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

/**
 * Created by aleran on 13.08.2015.
 */
@FindBy(xpath = ".")
public class DemographyMultiplierConditionBlock extends HtmlElement {

    @Name("пол")
    @FindBy(css = "div.b-adjustment-rates__control_type_gender input")
    private HierarchicalMultipliersRadioBEM gender;

    @Name("возраст")
    @FindBy(css = "div.b-adjustment-rates__control_type_age select")
    private SelectBEM age;

    @Name("Умножать на")
    @FindBy(css = ".b-adjustment-rates__control_type_input input")
    private TextInput demographyPctTextInput;

    public DemographyConditionWeb getDemographyConditionWeb(){
        return new DemographyConditionWeb()
                .withGender(gender.getSelectedButton().getAttribute("value"))
                .withAge(age.getSelectedText())
                .withMultiplierPct(demographyPctTextInput.getText());
    }

    public void fillDemographyCondition(DemographyConditionWeb demographyCondition){
        gender.selectByValue(demographyCondition.getGender());
        age.selectByVisibleText(demographyCondition.getAge());
        fillTextInput(demographyPctTextInput, demographyCondition.getMultiplierPct());
    }
}
