package ru.yandex.autotests.direct.web.pages.adjustment.blocks.conditions;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.adjustment.rates.DemographyConditionWeb;
import ru.yandex.autotests.direct.web.objects.adjustment.rates.MobileMultiplierWeb;
import ru.yandex.autotests.direct.web.webelements.bem.HierarchicalMultipliersRadioBEM;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

@FindBy(xpath = ".")
public class DevicesConditionBlock extends HtmlElement {

    @Name("Селект устройств")
    @FindBy(css = "button.b-adjustment-rates__button_action_toggle-device")
    private SelectBEM devicesTypes;

    @Name("увеличить/уменьшить")
    @FindBy(css = "span.b-adjustment-rates__sign select")
    private SelectBEM increaseSelect;

    @Name("Умножать на")
    @FindBy(css = ".b-adjustment-rates__control_type_input input")
    private TextInput pctTextInput;

    public MobileMultiplierWeb getMobileMultiplierWeb(){
        return new MobileMultiplierWeb()
                .withMultiplierPct(pctTextInput.getText());
    }

    public void fillDemographyCondition(MobileMultiplierWeb condition){
        fillTextInput(pctTextInput, condition.getMultiplierPct());
    }
}
