package ru.yandex.autotests.direct.web.pages.adjustment.blocks.conditions;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.adjustment.rates.RetargetingConditionWeb;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

/**
 * Created by aleran on 14.08.2015.
 */
@FindBy(xpath = ".")
public class RetargetingMultiplierConditionBlock  extends HtmlElement {

    @Name("Название условия ретаргетинга")
    @FindBy(css = ".b-adjustment-rates__button")
    private Button retargetingButton;

    @Name("Умножать на")
    @FindBy(css = ".b-adjustment-rates__control_type_input input")
    private TextInput retargetingPctTextInput;

    public RetargetingConditionWeb getRetargetingConditionWeb(){
        return new RetargetingConditionWeb()
                .withMultiplierPct(retargetingPctTextInput.getText());
    }

    public String getRetargetingName(){
        return retargetingButton.getWrappedElement().getText();
    }

    public void clickRetargetingButton(){
        retargetingButton.click();
    }

    public void fillRetargetingCondition(RetargetingConditionWeb retargetingCondition){
        fillTextInput(retargetingPctTextInput, retargetingCondition.getMultiplierPct());
    }
}
