package ru.yandex.autotests.direct.web.pages.agencies;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.CampaignInfoWeb;
import ru.yandex.autotests.direct.web.pages.agencies.blocks.AgencySearchCampaignTable;
import ru.yandex.autotests.direct.web.pages.agencies.blocks.AgencySearchClientTable;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

@NamedUrls({
        @NamedUrl(name = "agency.search", url = "/registered/main.pl?cmd=agSearch"),
})
public class AgSearchPage extends BasePageObject {

    private AgencySearchClientTable agencySearchClientTable;
    private AgencySearchCampaignTable agencySearchCampaignTable;

    @Name("Логин клиента")
    @FindBy(xpath = ".//input[@name='cl_login']")
    private TextInput clientLoginTextInput;

    @Name("Номер кампании")
    @FindBy(xpath = ".//input[@name='cid']")
    private TextInput campaignIDTextInput;

    @Name("Найти клиентов")
    @FindBy(xpath = ".//div[contains(@class, 'p-search__clients-form')]//button")
    private Button searchClientsButton;

    @Name("Найти кампании")
    @FindBy(xpath = ".//div[contains(@class, 'p-search__campaigns-form')]//button")
    private Button searchCampaignsButton;

    public void searchClient(String login) {
        fillTextInput(clientLoginTextInput, login);
        searchClientsButton.click();
    }

    public void searchCampaign(String campaignID) {
        fillTextInput(campaignIDTextInput, campaignID);
        searchCampaignsButton.click();
    }

    public void checkSearchClient(BeanEquals<AccountWeb> matcher) {
        agencySearchClientTable.checkSearchClientRow(matcher);
    }

    public void checkSearchCampaign(BeanEquals<CampaignInfoWeb> matcher) {
        agencySearchCampaignTable.checkSearchCampaignRow(matcher);
    }

}
