package ru.yandex.autotests.direct.web.pages.agencies.blocks;

import java.nio.charset.Charset;

import org.apache.http.client.utils.URLEncodedUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.web.objects.campaigns.CampaignInfoWeb;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;

@Name("Строка в таблице поиска кампаний")
@FindBy(xpath = ".//tr[contains(@class, 'b-campaigns-list__row')]")
public class AgencySearchCampaignRow extends HtmlElement {

    @Name("Название кампании")
    @FindBy(xpath = ".//td[2]/h3/a")
    private Link name;

    @Name("Номер кампании")
    @FindBy(xpath = ".//td[2]/div/span")
    private WebElement campaignID;


    public String getCampaignID() {
        return URLEncodedUtils.parse(name.getReference(), Charset.forName("UTF-8")).stream()
                .filter(t-> "cid".equals(t.getName()))
                .findFirst().get().getValue();
    }

    public void checkCampaignParameters(BeanEquals<CampaignInfoWeb> matcher) {
        assertThat("неверные параметры кампании", getCampaignFormFieldsAccording(matcher.getExpectedBean()),
                matcher);
    }

    public CampaignInfoWeb getCampaignFormFieldsAccording(CampaignInfoWeb expectedBean) {
        CampaignInfoWeb accountWeb = inAccordanceWith(expectedBean).forNew(CampaignInfoWeb.class)
                .set("name", name, on(Link.class).getText())
                .set("campaignId", this, on(AgencySearchCampaignRow.class).getCampaignID())
                .getActualBean();
        return accountWeb;
    }
}
