package ru.yandex.autotests.direct.web.pages.agencies.blocks;

import java.util.List;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.web.objects.campaigns.CampaignInfoWeb;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

@Name("Таблица с результатами поиска кампаний")
@FindBy(xpath = ".//table[contains(@class, 'b-campaigns-list__table')]")
public class AgencySearchCampaignTable extends HtmlElement {

    private List<AgencySearchCampaignRow> searchCampaignRows;

    private AgencySearchCampaignRow getSearchCampaignRow(String campaignID) {
        for (AgencySearchCampaignRow searchCampaign : searchCampaignRows) {
            if (searchCampaign.getCampaignID().equalsIgnoreCase(campaignID)) {
                return searchCampaign;
            }
        }
        return null;
    }

    public void checkSearchCampaignRow(BeanEquals<CampaignInfoWeb> matcher) {
        AgencySearchCampaignRow searchCampaignRow = getSearchCampaignRow(
                String.valueOf(matcher.getExpectedBean().getCampaignId()));
        if (searchCampaignRow == null) {
            throw new DirectWebError("Не найдена кампания: " + String.valueOf(matcher.getExpectedBean().getCampaignId()));
        } else {
            searchCampaignRow.checkCampaignParameters(matcher);
        }
    }
}
