package ru.yandex.autotests.direct.web.pages.agencies.blocks;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;


/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 13.02.14
 */

@Name("Строка в таблице поиска клиентов")
@FindBy(xpath = ".//tr[contains(@class, 'b-showclients-list__row')]")
public class AgencySearchClientRow extends HtmlElement {

    @Name("Логин")
    @FindBy(xpath = ".//td[3]/a")
    private Link login;

    @Name("ФИО клиента")
    @FindBy(xpath = ".//td[5]")
    private WebElement name;

    public String getLogin() {
        return login.getText();
    }

    public void checkClientParameters(BeanEquals<AccountWeb> matcher) {
        assertThat("неверные параметры клиента", getClientFormFieldsAccording(matcher.getExpectedBean()),
                matcher);
    }

    public AccountWeb getClientFormFieldsAccording(AccountWeb expectedBean) {
        AccountWeb accountWeb = inAccordanceWith(expectedBean).forNew(AccountWeb.class)
                .set("login", login, on(Link.class).getText())
                .set("name", name, on(WebElement.class).getText())
                .getActualBean();
        accountWeb.setRole(expectedBean.getRole());
        return accountWeb;
    }
}
