package ru.yandex.autotests.direct.web.pages.agencies.blocks;

import java.util.List;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.matchers.BeanEquals;
import ru.yandex.autotests.direct.web.objects.AccountWeb;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 13.02.14
 */

@Name("Таблица с результатами поиска клиентов")
@FindBy(xpath = ".//table[contains(@class, 'b-showclients-list__table')]")
public class AgencySearchClientTable extends HtmlElement {

    private List<AgencySearchClientRow> searchClientsRows;

    private AgencySearchClientRow getSearchClientsRow(String login) {
        for (AgencySearchClientRow searchClient : searchClientsRows) {
            if (searchClient.getLogin().equalsIgnoreCase(login)) {
                return searchClient;
            }
        }
        return null;
    }

    public void checkSearchClientRow(BeanEquals<AccountWeb> matcher) {
        AgencySearchClientRow searchAgencyRow = getSearchClientsRow(matcher.getExpectedBean().getLogin());
        if (searchAgencyRow == null) {
            throw new DirectWebError("Не найдено агентство: " + matcher.getExpectedBean().getLogin());
        } else {
            searchAgencyRow.checkClientParameters(matcher);
        }
    }
}
