package ru.yandex.autotests.direct.web.pages.alerts;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.WebElementsActions;
import ru.yandex.qatools.htmlelements.element.Button;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@FindBy(css = ".b-confirm")
public class AlertBlock1 extends ExtendedHtmlElement implements Alert {
    @FindBy(css = "button.b-confirm__yes")
    public Button yesButton;

    @FindBy(css = "button.b-confirm__no")
    public Button noButton;

    @FindBy(xpath = ".//div[@class='b-confirm__message']")
    public WebElement alertText;

    private WebElement getAlertText() {
        return alertText;
    }

    @Override
    public void clickYes() {
        new WebElementsActions(config).fireFocusEvent(yesButton);
        yesButton.click();
    }

    @Override
    public void clickNo() {
        new WebElementsActions(config).fireFocusEvent(yesButton);
        noButton.click();
    }

    @Override
    public void checkText(Matcher<String> matcher) {
        assertThat("неверный текст алерта", getAlertText().getText(), matcher);
    }

    @Override
    public String getAlertMessage() {
        return getAlertText().getText();
    }
}
