package ru.yandex.autotests.direct.web.pages.alerts;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.WebElementsActions;
import ru.yandex.qatools.htmlelements.element.Button;

import static org.hamcrest.MatcherAssert.assertThat;

@FindBy(xpath = "//div[contains(@class, 'b-user-dialog__content')]")
public class AlertBlock2 extends ExtendedHtmlElement implements Alert {
    @FindBy(xpath = ".//button[contains(@class, 'button_theme_action')]")
    public Button yesButton;

    @FindBy(xpath = ".//button[contains(@class, 'b-user-dialog__cancel')]")
    public Button noButton;

    @FindBy(xpath = "./div[contains(@class, 'b-user-dialog__body')]")
    public WebElement alertText;

    @Override
    public void clickYes() {
        new WebElementsActions(config).fireFocusEvent(yesButton);
        yesButton.click();
    }

    @Override
    public void clickNo() {
        new WebElementsActions(config).fireFocusEvent(noButton);
        noButton.click();
    }

    @Override
    public void checkText(Matcher<String> matcher) {
        assertThat("неверный текст алерта", alertText.getText(), matcher);
    }

    @Override
    public String getAlertMessage() {
        return alertText.getText();
    }
}
