package ru.yandex.autotests.direct.web.pages.api;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.api.APIRoleEnum;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.Link;

import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.isDisplayed;

public class APISandboxSettingsPage extends BasePageObject {

    private static final int TIMEOUT = 50;

    @Name("Ссылка 'Начать пользоваться песочницей'")
    @FindBy(xpath = ".//span[contains(@class, 'b-api-management-sandbox__begin-use-sandbox')]")
    private WebElement startUseSandboxLink;

    @Name("Роль")
    @FindBy(xpath = ".//input[@name = 'sandbox_client_type']")
    private RadioBEM clientRoleWebElement;

    @Name("Переключатель 'Создать тестовые кампании'")
    @FindBy(xpath = ".//input[@name = 'init_test_data']")
    private CheckBoxBEM createTestCampaigns;

    @Name("Кнопка 'Продолжить'")
    @FindBy(className = "b-api-management-sandbox__activate-form-submit")
    private Button continueButton;

    @Name("Ссылка 'Отмена'")
    @FindBy(className = "b-api-management-sandbox__activate-form-cancel")
    private Button cancelWebElement;

    @Name("Мастер-токен песочницы")
    @FindBy(className = "b-api-management-sandbox__master-token")
    private WebElement sandboxMasterToken;

    @Name("Ссылка 'Перестать пользоваться песочницей'")
    @FindBy(className = "b-api-management-sandbox__control-link_action_drop")
    private WebElement stopUseSandboxLink;

    @Name("Кнопка 'Да' при закрытии песочницы")
    @FindBy(className = "b-confirm__yes")
    private Button yesButton;

    @Name("Попап загрузки")
    @FindBy(css = "div.b-confirm__message")
    private WebElement waitingPopup;

    public boolean clickStopUseSandboxIfDisplayed() {
        return isDisplayed().matches(stopUseSandboxLink);
    }

    public void clickStartUseSandboxLink() {
            waitForElement(waitingPopup, TIMEOUT, not(isDisplayed()));
            waitForElement(startUseSandboxLink, TIMEOUT, isDisplayed());
            startUseSandboxLink.click();
    }

    public void selectRole(APIRoleEnum role) {
        if (role == null) {
            return;
        }
        clientRoleWebElement.selectByValue(role.getValue());
    }

    public void selectCreateTestCampaigns(Boolean status) {
        if (status == null) {
            return;
        }

        createTestCampaigns.set(status);
    }

    public void clickContinueButton() {
        waitForElement(continueButton.getWrappedElement(), TIMEOUT, isDisplayed());
        continueButton.click();
    }

    public String getSandboxMasterTokenValue() {
        waitForElement(sandboxMasterToken, TIMEOUT, isDisplayed());
        return sandboxMasterToken.getText();
    }

    public void clickStopUseSandboxLink() {
            waitForElement(waitingPopup, TIMEOUT, not(isDisplayed()));
            waitForElement(stopUseSandboxLink, TIMEOUT, isDisplayed());
            stopUseSandboxLink.click();
            if (yesButton.isDisplayed()) {
                yesButton.click();
            }
    }
}