package ru.yandex.autotests.direct.web.pages.api;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Link;

@Name("Настройки API - Параметры")
@NamedUrls(
        @NamedUrl(name = "open.apiSettings.page", url = "/registered/main.pl?cmd=apiSettings")
)
public class APISettingsPage extends BasePageObject {

    @Name("Ссылка 'Песочница'")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=apiSandboxSettings')]")
    private Link sandboxLink;

    @Name("Ссылка 'Песочница'")
    @FindBy(xpath = ".//a[contains(@href, 'cmd=apiFinanceSettings')]")
    private Link financeSettings;

    @Name("Заголовок страницы")
    @FindBy(xpath = ".//h1[contains(@class, 'b-header__h1')]")
    private WebElement header;

    public void clickSandboxLink() {
        sandboxLink.click();
    }

    public void clickFinanceSettingsLink() {
        financeSettings.click();
    }

    public WebElement getHeader() {
        return header;
    }
}
