package ru.yandex.autotests.direct.web.pages.api;

import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

@NamedUrls({
        @NamedUrl(name = "sms.auth", url = "/registered/main.pl?cmd=smsAuthentication&ulogin={1}")
})

public class APISmsAuthPage extends BasePageObject {

    @Name("Выписать новый мастер-токен")
    @FindBy(xpath = "(.//div[contains(@class, 'b-api-management-finance-settings__master-token')]//button)[1]")
    private Button newMasterToken;

    @Name("Сбросить мастер-токен")
    @FindBy(xpath = "(.//div[contains(@class, 'b-api-management-finance-settings__master-token')]//button)[2]")
    private Button deleteMasterToken;

    @Name("Сбросить значение счетчика")
    @FindBy(xpath = "(.//div[contains(@class, 'b-api-management-finance-settings__operations-counter')]//button)[1]")
    private Button deleteCounter;

    public void clickNewMasterToken() {
        newMasterToken.click();
    }

    public void clickDeleteMasterToken() {
        deleteMasterToken.click();
    }

    public void clickDeleteCounter() {
        deleteCounter.click();
    }
}