package ru.yandex.autotests.direct.web.pages.autopayment.blocks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBlockBEM;
import ru.yandex.autotests.irt.testutils.allure.AssumptionException;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static org.hamcrest.Matchers.containsString;


public class ChoosePaymentSelectBlock extends SelectBlockBEM {

    public ChoosePaymentSelectBlock(WebElement wrappedElement) {
        super(wrappedElement);
    }

    private WebElement getCard(String cardId) {
        return getOptions().stream()
                .filter(t -> getCardId(t).equals(cardId))
                .findFirst()
                .orElseThrow(() -> new AssumptionException("Ожидалось что списке есть карта с ид" + cardId));
    }

    public void unbindCard(String cardId) {
        openSelect();
        getCard(cardId).findElement(By.cssSelector("button")).click();
    }

    public String getSelectedCardId() {
        openSelect();
        return getCardId(getOptions().stream()
                .filter(this::isSelected)
                .findFirst()
                .orElseThrow(() -> new AssumptionException("Ожидалось, что есть выбранная карта")));
    }

    public String getCardId(WebElement element) {
        Pattern pattern = Pattern.compile("\"paymethodId\":\"([^\"]+)\"");
        Matcher matcher = pattern.matcher(element.getAttribute("data-bem"));
        if (matcher.find()) {
            return matcher.group(1);
        } else {
            throw new DirectWebError("Cannot find card Id");
        }
    }

    public boolean isSelected(WebElement element) {
        return WebElementMatchers.hasClass(containsString("b-chooser__item_selected_yes")).matches(element);
    }

    @Override
    protected WebElement getSelectButton() {
        return getWrappedElement()
                .findElement(By.xpath("//button[contains(@class, 'autopay-settings__switcher')]"));
    }
}
