package ru.yandex.autotests.direct.web.pages.banners;

import java.util.List;
import java.util.stream.Collectors;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.BannerPreviewType;
import ru.yandex.autotests.direct.web.objects.banners.BaseBannerWeb;
import ru.yandex.autotests.direct.web.objects.banners.DynamicTextBannerWeb;
import ru.yandex.autotests.direct.web.objects.groups.BaseGroupWeb;
import ru.yandex.autotests.direct.web.objects.groups.DynamicTextGroupWeb;
import ru.yandex.autotests.direct.web.pages.group.dynamictext.DynamicTextBannerBlock;
import ru.yandex.autotests.direct.web.pages.group.dynamictext.DynamicTextGroupBlock;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

@NamedUrls({
        @NamedUrl(name = "edit.bannergroup.dynamic.for.client",
                url = "/registered/main.pl?cmd=editDynamicAdGroups&bid={2}&cid={1}&ulogin={3}&adgroup_ids={4}"),
        @NamedUrl(name = "edit.dynamic.banner.texts",
                url = "/registered/main.pl?cmd=editDynamicAdGroupsLight&bid={2}&cid={1}&ulogin={3}&adgroup_ids={4}"),
        @NamedUrl(name = "add.dynamic.banner",
                url = "/registered/main.pl?cmd=addDynamicAdGroups&cid={1}&ulogin={2}")
})
public class AddAdGroupsDynamicPage extends BaseGroupPage {

    @Name("Кнопка добавления нового объявления")
    @FindBy(xpath = ".//button[contains(@class,'b-edit-banner-add2__add-button')]")
    private Button addNewBannerButton;

    @Name("Блок параметров на всю группу")
    @FindBy(xpath = ".//div[contains(@class,'b-edit-group__grey-wrapper')]")
    private WebElement groupParametrsBlock;

    private List<DynamicTextGroupBlock> dynamicTextGroupBlocks;

    private List<DynamicTextGroupBlock> getDynamicTextGroupBlocks() {
        return dynamicTextGroupBlocks;
    }

    @Override
    public void fillGroupParameters(BaseGroupWeb baseGroupWeb) {
        DynamicTextGroupWeb dynamicTextGroupWeb = (DynamicTextGroupWeb) baseGroupWeb;
        DynamicTextGroupBlock dynamicTextGroupBlock = getEditGroupWithBannerBlock(adGroupId);
        dynamicTextGroupBlock.fillParameters(dynamicTextGroupWeb);
    }

    @Override
    public void fillBannerParameters(BaseBannerWeb baseBannerWeb) {
        DynamicTextBannerWeb dynamicTextBannerWeb = (DynamicTextBannerWeb) baseBannerWeb;
        DynamicTextGroupBlock dynamicTextGroupBlock = getEditGroupWithBannerBlock(adGroupId);
        dynamicTextGroupBlock.fillBanner(dynamicTextBannerWeb);
    }

    @Override
    public void checkGroupParameters(BaseGroupWeb baseGroupWeb) {
        DynamicTextGroupWeb dynamicTextGroupWeb = (DynamicTextGroupWeb) baseGroupWeb;
        DynamicTextGroupBlock bannerBlock = getEditGroupWithBannerBlock(adGroupId);
        BeanDifferMatcher<DynamicTextGroupWeb> beanDiffer = BeanDifferMatcher.beanDiffer(dynamicTextGroupWeb);
        beanDiffer.useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields());
        bannerBlock.checkParameters(beanDiffer);
    }

    @Override
    public void checkBannerParameters(BaseBannerWeb baseBannerWeb) {
        DynamicTextBannerWeb dynamicTextBannerWeb = (DynamicTextBannerWeb) baseBannerWeb;
        DynamicTextGroupBlock bannerBlock = getEditGroupWithBannerBlock(adGroupId);
        BeanDifferMatcher<DynamicTextBannerWeb> beanDiffer = BeanDifferMatcher.beanDiffer(dynamicTextBannerWeb);
        baseBannerWeb.setAdGroupId(null);
        //hack: порядок появления калаутов недетерминирован, поэтому явно сортируем лист
        List<String> callouts = dynamicTextBannerWeb.getCallouts();
        if(callouts != null) {
            dynamicTextBannerWeb.setCallouts(callouts.stream().sorted().collect(Collectors.toList()));
        }
        beanDiffer.useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields());
        bannerBlock.checkBannerParameters(beanDiffer, bannerId);
        //hack: возвращаем исходный порядок уточнений
        dynamicTextBannerWeb.setCallouts(callouts);
    }

    @Override
    public void checkHierarchicalMultipliersParameters(BaseGroupWeb baseGroupWeb) {
    }

    @Override
    public void fillRegions(BaseGroupWeb baseGroupWeb) {
        DynamicTextGroupWeb dynamicTextGroupWeb = (DynamicTextGroupWeb) baseGroupWeb;
        DynamicTextGroupBlock bannerBlock = getEditGroupWithBannerBlock(adGroupId);
        bannerBlock.fillRegions(dynamicTextGroupWeb.getGeoTags());
    }

    @Override
    public void checkBannersCount(int count) {

    }

    @Override
    public void clickAddNewBannerButton() {
        addNewBannerButton.click();
    }

    private DynamicTextGroupBlock getEditGroupWithBannerBlock(Long adGroupId) {
        DynamicTextGroupBlock block = getDynamicTextGroupBlocks().stream()
                .filter(t -> adGroupId.equals(t.getGroupId()))
                .findFirst().orElse(null);
        if (block != null) {
            block.setConfig(config);
        } else {
            throw new DirectWebError("Не найден баннер " + bannerId + " в группе " + adGroupId);
        }
        return block;
    }

    public DynamicTextBannerBlock getBannerBlockById(Long groupId, Long adId) {
        DynamicTextGroupBlock groupBlock = getEditGroupWithBannerBlock(groupId);
        return groupBlock.getBannerBlockById(adId);
    }

    public WebElement getBannerPreviewById(Long groupId, Long adId) {
        return getBannerBlockById(groupId, adId).getBannerPreview();
    }

    @Override
    public void chooseBannerPreviewType(Long adgroupId, Long banner, BannerPreviewType prevType) {
        getBannerBlockById(adgroupId, banner).clickBannerPreviewType(prevType);
    }

    public WebElement getGroupParametrsBlock() {
        return groupParametrsBlock;
    }

    @Override
    public void openMinusWordsPopup(Long adgroupId) {
        getEditGroupWithBannerBlock(adgroupId).openMinusWordsPopup();
    }

    @Override
    public void openRegionsPopup(Long adgroupId) {
        getEditGroupWithBannerBlock(adgroupId).openRegionsPopup();
    }

    @Override
    public void openAdjustmentRatesPopup(Long adgroupId) {
        getEditGroupWithBannerBlock(adgroupId).openAdjustmentRatesPopup();
    }

    @Override
    public void openSiteLinksPopupInBanner(Long adgroupId, Long banner) {
        getBannerBlockById(adgroupId, banner).clickSiteLinksButton();
    }

    @Override
    public void openCalloutsPopupInBanner(Long adgroupId, Long banner) {
        getBannerBlockById(adgroupId, banner).clickCalloutsButton();
    }

    @Override
    public void openEditFilterPopup(Long adgroupId, String filterName) {
        getEditGroupWithBannerBlock(adgroupId).openFilterPopup(filterName);
    }

}
