package ru.yandex.autotests.direct.web.pages.banners;

import java.util.List;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.BannerPreviewType;
import ru.yandex.autotests.direct.web.data.banners.PerformanceGroupChangesInfo;
import ru.yandex.autotests.direct.web.objects.banners.BaseBannerWeb;
import ru.yandex.autotests.direct.web.objects.banners.PerformanceBannerWeb;
import ru.yandex.autotests.direct.web.objects.groups.BaseGroupWeb;
import ru.yandex.autotests.direct.web.objects.groups.PerformanceGroupWeb;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.PerformanceGroupChangesBlockBEM;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.peformance.PerformanceBannerBlock;
import ru.yandex.autotests.direct.web.pages.group.performance.EditPerformanceGroupWithBannerBlock;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;
import static ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies.onlyExpectedFields;

/**
 * Created by aleran on 24.11.2015.
 */
@NamedUrls({
        @NamedUrl(name = "edit.banner.performance", url =
                "/registered/main.pl?cmd=editAdGroupsPerformance&bid={2}&cid={1}" +
                        "&adgroup_ids={3}"),
        @NamedUrl(name = "edit.banner.performance.for.client",
                url = "/registered/main.pl?cmd=editAdGroupsPerformance&bid={2}&cid={1}&ulogin={3}&adgroup_ids={4}"),
        @NamedUrl(name = "edit.bannergroup.performance", url = "/registered/main.pl?cmd=editAdGroupsPerformance&cid={1}"
                +
                "&adgroup_ids={2}&bid={3}"),
        @NamedUrl(name = "edit.bannergroup.performance.for.client",
                url = "/registered/main.pl?cmd=editAdGroupsPerformance&cid={1}&ulogin={2}&adgroup_ids={3}&bid={4}"),
        @NamedUrl(name = "add.bannergroup.performance.for.client",
                url = "/registered/main.pl?cmd=addAdGroupsPerformance&cid={1}&ulogin={2}&new_group=1")
})
public class AddAdGroupsPerformancePage extends BaseGroupPage {
    @Name("Кнопка добавления нового объявления")
    @FindBy(xpath = ".//button[contains(@class,'b-edit-banner-add2__add-button')]")
    private Button addNewBannerButton;

    @Name("Блок параметров на всю группу")
    @FindBy(xpath = ".//div[contains(@class,'b-edit-group__grey-wrapper')]")
    private WebElement groupParametrsBlock;

    @Name("Групповые изменения")
    @FindBy(xpath = ".//button[contains(@class, 'b-edit-groups-mass-actions-toggle__popup-toggle-link')]")
    private Button groupChangesButton;

    private PerformanceGroupChangesBlockBEM groupChangesBlock;

    private List<EditPerformanceGroupWithBannerBlock> performanceGroupBlockList;

    private List<EditPerformanceGroupWithBannerBlock> getPerformanceGroupBlockList() {
        return performanceGroupBlockList;
    }

    private EditPerformanceGroupWithBannerBlock getEditGroupWithBannerBlock(Long adGroupId) {
        EditPerformanceGroupWithBannerBlock block = getPerformanceGroupBlockList().stream()
                .filter(t -> adGroupId.equals(t.getGroupId()))
                .findFirst().orElseThrow(() -> new DirectWebError("Не найдена группа " + adGroupId));
        block.setConfig(config);
        return block;
    }

    @Override
    public void fillGroupParameters(BaseGroupWeb baseGroupWeb) {
        PerformanceGroupWeb performanceGroupWeb = (PerformanceGroupWeb) baseGroupWeb;
        EditPerformanceGroupWithBannerBlock bannerBlock = getEditGroupWithBannerBlock(adGroupId);
        bannerBlock.fillParameters(performanceGroupWeb);
    }

    @Override
    public void fillRegions(BaseGroupWeb baseGroupWeb) {
        PerformanceGroupWeb performanceGroupWeb = (PerformanceGroupWeb) baseGroupWeb;
        EditPerformanceGroupWithBannerBlock bannerBlock = getEditGroupWithBannerBlock(adGroupId);
        bannerBlock.fillRegions(performanceGroupWeb.getGeoTags());
    }

    @Override
    public void fillBannerParameters(BaseBannerWeb baseBannerWeb) {
        PerformanceBannerWeb performanceBannerWeb = (PerformanceBannerWeb) baseBannerWeb;
        EditPerformanceGroupWithBannerBlock bannerBlock = getEditGroupWithBannerBlock(adGroupId);
        bannerBlock.fillBannerParametersUsingListMode(performanceBannerWeb);
    }

    @Override
    public void checkGroupParameters(BaseGroupWeb baseGroupWeb) {
        PerformanceGroupWeb performanceGroupWeb = (PerformanceGroupWeb) baseGroupWeb;
        EditPerformanceGroupWithBannerBlock groupBlock = getEditGroupWithBannerBlock(adGroupId);
        groupBlock.checkParameters(beanDiffer(performanceGroupWeb).useCompareStrategy(onlyExpectedFields()));
    }

    @Override
    public void checkBannerParameters(BaseBannerWeb baseBannerWeb) {
        PerformanceBannerWeb performanceBannerWeb = (PerformanceBannerWeb) baseBannerWeb;
        EditPerformanceGroupWithBannerBlock bannerBlock = getEditGroupWithBannerBlock(adGroupId);
        bannerBlock.checkBannerParameters(beanDiffer(performanceBannerWeb).useCompareStrategy(onlyExpectedFields()));
    }

    @Override
    public void checkHierarchicalMultipliersParameters(BaseGroupWeb baseGroupWeb) {
        EditPerformanceGroupWithBannerBlock groupBlock = getEditGroupWithBannerBlock(adGroupId);
        groupBlock.checkHierarchicalMultipliersParameters(baseGroupWeb.getHierarchicalMultipliersWeb());
    }

    @Override
    public void checkBannersCount(int count) {

    }

    @Override
    public void clickAddNewBannerButton() {
        addNewBannerButton.click();
    }

    public PerformanceBannerBlock getBannerBlockById(Long groupId, Long adId) {
        EditPerformanceGroupWithBannerBlock groupBlock = getEditGroupWithBannerBlock(Long.valueOf(groupId));
        return groupBlock.getBannerBlock(adId);
    }

    @Override
    public void chooseBannerPreviewType(Long adgroupId, Long banner, BannerPreviewType prevType) {
    }

    public WebElement getGroupParametrsBlock() {
        return groupParametrsBlock;
    }

    @Override
    public void openMinusWordsPopup(Long adgroupId) {
        getEditGroupWithBannerBlock(Long.valueOf(adgroupId)).openMinusWordsPopup();
    }

    @Override
    public void openRegionsPopup(Long adgroupId) {
        getEditGroupWithBannerBlock(Long.valueOf(adgroupId)).openRegionsPopup();
    }

    @Override
    public void openAdjustmentRatesPopup(Long adgroupId) {
        getEditGroupWithBannerBlock(Long.valueOf(adgroupId)).openAdjustmentRatesPopup();
    }

    @Override
    public void openSiteLinksPopupInBanner(Long adgroupId, Long banner) {
    }

    @Override
    public void openCalloutsPopupInBanner(Long adgroupId, Long banner) {
    }

    @Override
    public void openEditFilterPopup(Long adgroupId, String filterName) {
        getEditGroupWithBannerBlock(adgroupId).openFilterPopup(filterName);
    }

    @Step("Заполняем групповые изменения")
    public void fillGroupChanges(PerformanceGroupChangesInfo changesInfo) {
        getGroupChangesBlock().fill(changesInfo);
    }

    @Step("Открыть попап групповых изменений")
    public void openGroupChanges() {
        groupChangesButton.click();
    }

    private PerformanceGroupChangesBlockBEM getGroupChangesBlock() {
        groupChangesBlock.setConfig(config);
        return groupChangesBlock;
    }
}
