package ru.yandex.autotests.direct.web.pages.banners;
import java.util.List;
import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.data.BannerPreviewType;
import ru.yandex.autotests.direct.web.data.banners.BannersGroupErrorResource;
import ru.yandex.autotests.direct.web.data.banners.GroupChangesBlockTabs;
import ru.yandex.autotests.direct.web.data.banners.GroupChangesInfo;
import ru.yandex.autotests.direct.web.data.banners.ImageLoadType;
import ru.yandex.autotests.direct.web.objects.adjustment.rates.HierarchicalMultipliersWeb;
import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.OptimizedPhraseInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.SiteLinkInfoWeb;
import ru.yandex.autotests.direct.web.objects.retargeting.RetargetingConditionWeb;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.EditGroupWithBannerBlockBEM;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.GroupChangesBlockBEM;
import ru.yandex.autotests.direct.web.pages.retargeting.blocks.bem.RetargetingPopupBlockBEM;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
/**
 *         Страница редактирования групп и баннеров в старом интерфейсе
 */
@NamedUrls({
        @NamedUrl(name = "edit.banner", url = "/registered/main.pl?cmd=showCampMultiEdit&bids={2}&cid={1}" +
                "&adgroup_ids={3}"),
        @NamedUrl(name = "edit.banner.for.client",
                url = "/registered/main.pl?cmd=showCampMultiEdit&bids={2}&cid={1}&ulogin={3}&adgroup_ids={4}"),
        @NamedUrl(name = "edit.bannergroup", url = "/registered/main.pl?cmd=showCampMultiEdit&cid={1}" +
                "&adgroup_ids={2}"),
        @NamedUrl(name = "edit.bannergroup.for.client",
                url = "/registered/main.pl?cmd=showCampMultiEdit&cid={1}&ulogin={2}&adgroup_ids={3}"),
        @NamedUrl(name = "edit.dynamicgroup.for.client",
                url = "/registered/main.pl?cmd=editDynamicAdGroups&cid={1}&ulogin={2}&adgroup_ids={3}"),
        @NamedUrl(name = "edit.banner.texts",
                url = "/registered/main.pl?cmd=showCampMultiEditLight&bids={2}&cid={1}&ulogin={3}&adgroup_ids={4}"),
        @NamedUrl(name = "new.banner",
                url = "/registered/main.pl?cid={1}&cmd=addBannerMultiEdit&from_newCamp=1&ulogin={2}")
})
public class AddBannerMultiEditPage extends BasePageObject {
    private GroupChangesBlockBEM groupChangesBlock;
    private List<RetargetingPopupBlockBEM> retargetingPopupBlockList;
    //region Fields
    private List<EditGroupWithBannerBlockBEM> groupBlockList;
    private Long bannerId;
    private Long adGroupId;
    @Name("Групповые изменения")
    @FindBy(xpath = ".//button[contains(@class, 'b-edit-groups-mass-actions-toggle__popup-toggle-link')]")
    private Button groupChangesButton;
    @Name("Кнопка '< Назад'")
    @FindBy(xpath = ".//button[contains(@class, 'p-multiedit') and contains(@class, 'back-button')]")
    private Button backButton;
    @Name("Кнопка 'Вперед >'")
    @FindBy(xpath = ".//button[contains(@class, 'p-multiedit')" +
            " and (contains(@class, 'submit-button') or contains(@class, 'next-button'))]")
    private Button nextButton;
    @Name("Кнопка 'Добавить объявление'")
    @FindBy(xpath = ".//button[contains(@class, 'b-edit-banner-add2__add-button')]")
    private Button addBannerButton;
    @Name("Сообщение об ошибке")
    @FindBy(css = ".b-edit-groups-error-header__message")
    private WebElement errorMessage;
    public void forBannerId(Long bannerId) {
        this.bannerId = bannerId;
    }
    public void forAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }
    //endregion
    //region Field getters
    private GroupChangesBlockBEM getGroupChangesBlock() {
        groupChangesBlock.setConfig(config);
        return groupChangesBlock;
    }
    private List<EditGroupWithBannerBlockBEM> getGroupBlockList() {
        return groupBlockList;
    }
    private List<RetargetingPopupBlockBEM> getRetargetingPopupBlockList() {
        return retargetingPopupBlockList;
    }
    private EditGroupWithBannerBlockBEM getEditGroupWithBannerBlock(Long adGroupId, Long bannerId) {
        EditGroupWithBannerBlockBEM block = getGroupBlockList().stream()
                .filter(t -> t.getAdGroupID().equals(adGroupId))
                .findFirst().get();
        if (block != null) {
            block.forBannerId(bannerId);
            block.setConfig(config);
        } else {
            throw new DirectWebError("Не найден баннер " + bannerId + " в группе " + adGroupId);
        }
        return block;
    }
    //endregion
    //region Actions
    public void clickNext() {
        nextButton.click();
    }
    public void clickBack() {
        backButton.click();
    }
    public void clickGroupChangesButton() {
        groupChangesButton.click();
    }
    public void editPhraseText(OptimizedPhraseInfoWeb phrase, String newPhraseText) {
        EditGroupWithBannerBlockBEM block = getEditGroupWithBannerBlock(adGroupId, bannerId);
        block.editPhraseText(phrase.getPhrase(), newPhraseText);
    }
    public void addRetargetingCondition(RetargetingConditionWeb conditionWeb) {
        EditGroupWithBannerBlockBEM bannerBlock = getEditGroupWithBannerBlock(adGroupId, bannerId);
        bannerBlock.clickAddRetargetingCondition();
        bannerBlock.addNewRetargetingCondition(conditionWeb);
    }
    public void editRetargetingCondition(RetargetingConditionWeb conditionWeb) {
        EditGroupWithBannerBlockBEM bannerBlock = getEditGroupWithBannerBlock(adGroupId, bannerId);
        bannerBlock.clickEditCondition(conditionWeb.getRetargetingConditionName());
        bannerBlock.addNewRetargetingCondition(conditionWeb);
    }
    public void addSavedRetargetingCondition(String conditionName) {
        EditGroupWithBannerBlockBEM bannerBlock = getEditGroupWithBannerBlock(adGroupId, bannerId);
        bannerBlock.clickAddRetargetingCondition();
        bannerBlock.addSavedRetargetingCondition(conditionName);
    }
    public void editSavedRetargetingCondition(String conditionName, RetargetingConditionWeb conditionWeb) {
        EditGroupWithBannerBlockBEM bannerBlock = getEditGroupWithBannerBlock(adGroupId, bannerId);
        bannerBlock.clickAddRetargetingCondition();
        bannerBlock.editSavedRetargetingCondition(conditionName, conditionWeb);
    }
    public void deleteRetargetingCondition(String conditionName) {
        EditGroupWithBannerBlockBEM bannerBlock = getEditGroupWithBannerBlock(adGroupId, bannerId);
        bannerBlock.deleteCondition(conditionName);
    }
    public void checkRetargetingConditionParameters(RetargetingConditionWeb conditionWeb) {
        EditGroupWithBannerBlockBEM bannerBlock = getEditGroupWithBannerBlock(adGroupId, bannerId);
        bannerBlock.checkRetargetingConditionParameters(conditionWeb);
    }
    public void checkHierarchicalMultipliersParameters(HierarchicalMultipliersWeb hierarchicalMultipliers) {
        EditGroupWithBannerBlockBEM bannerBlock = getEditGroupWithBannerBlock(adGroupId, bannerId);
        bannerBlock.checkHierarchicalMultipliersParameters(hierarchicalMultipliers);
    }
    public void checkRetargetingConditionsList(Matcher matcher) {
        assertThat("неправильные парамерты списка условий ретаргетинга", getRetargetingPopupBlockList(), matcher);
    }
    public void clickAddNewBanner() {
        addBannerButton.click();
    }
    public void fillBannerParameters(BannerInfoWeb bannerInfo) {
        EditGroupWithBannerBlockBEM bannerBlock = getEditGroupWithBannerBlock(adGroupId, bannerId);
        bannerBlock.fillParameters(bannerInfo);
    }
    public void fillGroupMinusKeywords(BannerInfoWeb bannerInfo) {
        EditGroupWithBannerBlockBEM bannerBlock = getEditGroupWithBannerBlock(adGroupId, bannerId);
        if (bannerBlock == null) {
            throw new DirectWebError("Не найден баннер " + bannerId + " в группе " + adGroupId);
        } else {
            bannerBlock.fillMinusKeyWords(bannerInfo.getMinusKeywords());
        }
    }
    public void fillSiteLinks(String link, SiteLinkInfoWeb[] sitelinks) {
        EditGroupWithBannerBlockBEM bannerBlock = getEditGroupWithBannerBlock(adGroupId, bannerId);
        bannerBlock.fillSitelinks(link, sitelinks);
    }
    public void checkBannerPhraseList(Matcher matcher) {
        EditGroupWithBannerBlockBEM bannerBlock = getEditGroupWithBannerBlock(adGroupId, bannerId);
        bannerBlock.checkPhraseList(matcher);
    }
    public void checkBannerParameters(BannerInfoWeb expectedBannerInfo) {
        EditGroupWithBannerBlockBEM bannerBlock = getEditGroupWithBannerBlock(adGroupId, bannerId);
        new JavaScriptActions(config).scrollToElement(bannerBlock.getWrappedElement());
        bannerBlock.checkParameters(expectedBannerInfo);
    }
    public void checkBannersCount(int count) {
        assertThat("кол-во баннеров соответствует",
                getEditGroupWithBannerBlock(adGroupId, bannerId).getBannerBlockBEMs().size(),
                equalTo(count));
    }
    public void checkErrorTextPresent(BannersGroupErrorResource error) {
        assertThat("ошибка соответствует ожидаемой", errorMessage.getText(), equalTo(error.toString()));
    }
    public void clickRefinePhraseButton(String phraseText) {
        EditGroupWithBannerBlockBEM bannerBlock = getEditGroupWithBannerBlock(adGroupId, bannerId);
        bannerBlock.clickRefineButtonForPhrase(phraseText);
    }
    public void fillGroupEditParameters(GroupChangesInfo groupChangesInfo) {
        groupChangesButton.click();
        getGroupChangesBlock().fill(groupChangesInfo);
    }
    public void openGroupChangesTab(GroupChangesBlockTabs groupChangesBlockTabs) {
        groupChangesButton.click();
        getGroupChangesBlock().openGroupChangesTab(groupChangesBlockTabs);
    }
    public void checkGroupChangesSiteLinksPopupParameters(SiteLinkInfoWeb[] siteLinks) {
        getGroupChangesBlock().checkSiteLinks(siteLinks);
    }
    public void bannerEditBlockListShould(Matcher matcher) {
        assertThat("ошибка при проверке списка редактирования баннеров", getGroupBlockList(), matcher);
    }
    public void checkImage(Matcher matcher) {
        EditGroupWithBannerBlockBEM bannerBlock = getEditGroupWithBannerBlock(adGroupId, bannerId);
        bannerBlock.checkImageOnPopup(matcher);
    }
    public void fillImageAndSave(ImageLoadType type, String img) {
        EditGroupWithBannerBlockBEM bannerBlock = getEditGroupWithBannerBlock(adGroupId, bannerId);
        bannerBlock.fillImageAndSave(type, img);
    }
    public void removeImage() {
        EditGroupWithBannerBlockBEM bannerBlock = getEditGroupWithBannerBlock(adGroupId, bannerId);
        bannerBlock.removeImg();
    }
    public void checkMobileCheckboxShouldBe(Matcher<TypifiedElement> matcher) {
        EditGroupWithBannerBlockBEM bannerBlock = getEditGroupWithBannerBlock(adGroupId, bannerId);
        bannerBlock.checkMobileCheckboxShouldBe(matcher);
    }
    public RadioBEM getTargetingConditions(Long adGroupId) {
        return groupBlockList.stream()
                .filter(t -> t.getAdGroupID().equals(adGroupId))
                .findFirst().get().getTargetingConditions();
    }
    public void choosePreviewTypeForBanner(Long adGroupId, Long bannerId, BannerPreviewType type) {
        getGroupBlock(adGroupId).chooseBannerPreviewType(bannerId, type);
    }
    private EditGroupWithBannerBlockBEM getGroupBlock(Long adGroupId) {
        EditGroupWithBannerBlockBEM block = getGroupBlockList().stream()
                .filter(t -> t.getAdGroupID().equals(adGroupId))
                .findFirst().orElseThrow(() -> new DirectWebError("Не найдена группа " + adGroupId));
        block.setConfig(config);
        return block;
    }
    public void openRetargetingPopupInGroup(Long adgroupId) {
        getGroupBlock(adgroupId).openRetargetingPopup();
    }
    public void openRegionsPopupInGroup(Long adgroupId) {
        getGroupBlock(adgroupId).openRegionsPopup();
    }
    public void openAdjustmentRatesPopupInGroup(Long adgroupId) {
        getGroupBlock(adgroupId).openAdjustmentRatesPopup();
    }
    public void openMinusWordsPopupInGroup(Long adgroupId) {
        getGroupBlock(adgroupId).openMinusWordsPopup();
    }
    public void openImagePopupInBanner(Long adgroupId, Long bannerId) {
        getGroupBlock(adgroupId).getEditBannerBlock(bannerId).openImagePopop();
    }
    public void openCalloutsPopupInBanner(Long adgroupId, Long bannerId) {
        getGroupBlock(adgroupId).getEditBannerBlock(bannerId).openCalloutsPopop();
    }
    public void openSiteLinksPopupInBanner(Long adgroupId, Long bannerId) {
        getGroupBlock(adgroupId).getEditBannerBlock(bannerId).openSiteLinksPopop();
    }
    public void fillRegions(BannerInfoWeb bannerInfo) {
        getGroupBlock(bannerInfo.getAdGroupID()).fillRegions(bannerInfo.getGeo());
    }
    //endregion
}