package ru.yandex.autotests.direct.web.pages.banners;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.BannerPreviewType;
import ru.yandex.autotests.direct.web.objects.banners.BaseBannerWeb;
import ru.yandex.autotests.direct.web.objects.groups.BaseGroupWeb;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

/**
 * Created by aleran on 24.11.2015.
 */
public abstract class BaseGroupPage extends BasePageObject {

    protected Long bannerId;
    protected Long adGroupId;

    @Name("Кнопка '< Назад'")
    @FindBy(xpath = ".//button[contains(@class, 'p-multiedit') and contains(@class, 'back-button')]")
    private Button backButton;

    @Name("Кнопка 'Дальше/Сохранить'")
    @FindBy(xpath = ".//button[contains(@class, 'p-multiedit')" +
            " and (contains(@class, 'submit-button') or contains(@class, 'next-button'))]")
    private Button nextButton;

    public void forBannerId(Long bannerId) {
        this.bannerId = bannerId;
    }

    public void forAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    public abstract void fillGroupParameters(BaseGroupWeb baseGroupWeb);

    public abstract void fillRegions(BaseGroupWeb baseGroupWeb);

    public abstract void fillBannerParameters(BaseBannerWeb baseBannerWeb);

    public abstract void checkGroupParameters(BaseGroupWeb baseGroupWeb);

    public abstract void checkBannerParameters(BaseBannerWeb baseBannerWeb);

    public abstract void checkHierarchicalMultipliersParameters(BaseGroupWeb baseGroupWeb);

    public abstract void checkBannersCount(int count);

    public abstract void clickAddNewBannerButton();

    public abstract void chooseBannerPreviewType(Long adgroupId, Long banner, BannerPreviewType prevType);

    public abstract void openMinusWordsPopup(Long adgroupId);

    public abstract void openRegionsPopup(Long adgroupId);

    public abstract void openAdjustmentRatesPopup(Long adgroupId);

    public abstract void openSiteLinksPopupInBanner(Long adgroupId, Long banner);

    public abstract void openCalloutsPopupInBanner(Long adgroupId, Long banner);

    public abstract void openEditFilterPopup(Long adgroupId, String filterName);

    public void clickNext() {
        nextButton.click();
    }

    public void clickBack() {
        backButton.click();
    }

    public void clickSaveGroup() {
        nextButton.click();
    }
}
