package ru.yandex.autotests.direct.web.pages.banners;

import java.util.List;
import java.util.Optional;

import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.banners.CpmBannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.groups.CpmGroupInfoWeb;
import ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem.EditGroupWithCpmBannerBlockBem;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;

import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@NamedUrls({
        @NamedUrl(name = "edit.bannergroup.cpm.for.client",
                url = "/registered/main.pl?cmd=editAdGroupsCpmBanner&cid={1}&ulogin={2}&adgroup_ids={3}"),
        @NamedUrl(name = "add.bannergroup.cpm.for.client",
                url = "/registered/main.pl?cmd=saveCpmBannerAdGroups&cid={1}&ulogin={2}"),
        @NamedUrl(name = "edit.bannergroup.cpm",
                url = "/registered/main.pl?cmd=editAdGroupsCpmBanner&cid={1}&adgroup_ids={2}")
})
public class EditGroupsCpmPage extends BasePageObject {

    @Name("Кнопка 'Сохранить'")
    @FindBy(xpath = ".//button[contains(@class, 'p-multiedit')" +
            " and (contains(@class, 'submit-button') or contains(@class, 'next-button'))]")
    private Button saveButton;

    private List<EditGroupWithCpmBannerBlockBem> groups;

    public void fillGroups(List<CpmGroupInfoWeb> groupInfoWebs) {
        groupsHaveExpectedSize(groupInfoWebs);
        for (int i = 0; i < groups.size(); i++) {
            EditGroupWithCpmBannerBlockBem currentGroup = groups.get(i);
            currentGroup.setConfig(config);
            currentGroup.fillParameters(groupInfoWebs.get(i));
        }
    }

    public void clickOnAddNewBannerButton(Long adGroupId) {
        getGroupBlock(adGroupId)
                .orElseThrow(() -> new DirectWebError("Не найдена группа с Id: " + adGroupId))
                .clickOnAddNewBannerButton();
    }

    public void fillBannerWithId(CpmBannerInfoWeb cpmBannerInfoWeb, Long adGroupId) {
        EditGroupWithCpmBannerBlockBem currentGroup = getGroupBlock(adGroupId)
                .orElseThrow(() -> new DirectWebError("Не найдена группа с Id: " + adGroupId));
        currentGroup.setConfig(config);
        currentGroup.fillBannerWithId(cpmBannerInfoWeb);
    }

    public void clickSave() {
        saveButton.click();
    }

    private void groupsHaveExpectedSize(List<CpmGroupInfoWeb> groupInfoWebs) {
        assumeThat("количество групп соответствует ожидаемому", groupInfoWebs.size(), equalTo(groups.size()));
    }

    public void checkParameters(List<CpmGroupInfoWeb> cpmGroupInfoWebs) {
        assertThat("количество групп соответствует ожиданию", groups.size(), equalTo(cpmGroupInfoWebs.size()));
        for (int i = 0; i < cpmGroupInfoWebs.size(); i++) {
            EditGroupWithCpmBannerBlockBem currentGroup = groups.get(i);
            currentGroup.setConfig(config);
            currentGroup.checkParameters(cpmGroupInfoWebs.get(i));
        }
    }

    private Optional<EditGroupWithCpmBannerBlockBem> getGroupBlock(Long adGroupId) {
        return groups.stream()
                .filter(groupBlock -> groupBlock.getAdGroupId().equals(adGroupId))
                .findFirst();
    }
}