package ru.yandex.autotests.direct.web.pages.banners;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import ru.yandex.autotests.direct.web.data.CheckBoxStates;
import ru.yandex.autotests.direct.web.data.RadioInputMethod;
import ru.yandex.autotests.direct.web.data.SelectInputMethod;
import ru.yandex.autotests.direct.web.objects.banners.SearchBannersInfoWeb;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrl;
import ru.yandex.qatools.allure.webdriver.annotations.NamedUrls;
import ru.yandex.qatools.allure.webdriver.pages.BasePageObject;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import static ru.yandex.autotests.direct.web.util.WebElementsActions.*;

@NamedUrls(@NamedUrl(name = "search.banners", url = "/registered/main.pl?cmd=searchBanners"))
public class SearchBannersPage extends BasePageObject {

    @Name("Кнопка тип баннера - директ")
    @FindBy(xpath = ".//input[@name='where']")
    private RadioBEM bannerTypeRadio;

    @Name("Радиогруппа 'Искать по'")
    @FindBy(xpath = ".//input[contains(@value,'num')]")
    private RadioBEM searchTypeRadio;

    @Name("Поле ввода текста для поиска")
    @FindBy(xpath = ".//input[@name='text_search']")
    private TextInput searchTextInput;

    @Name("Чекбокс - 'Искать только по активным баннерам'")
    @FindBy(xpath = ".//input[@name='activeonly']")
    private CheckBoxBEM activeOnlyCheckbox;

    @Name("Чекбокс - 'Группировать по кампаниям'")
    @FindBy(xpath = ".//input[@name='group_camp']")
    private CheckBoxBEM groupCampCheckbox;

    @Name("Чекбокс - 'Показывать старые кампании в у.е.'")
    @FindBy(xpath = ".//input[@name='include_currency_archived_campaigns']")
    private CheckBoxBEM currencyArchivedCampaignsCheckbox;

    @Name("Чекбокс - 'Искать по точному соответствию'")
    @FindBy(xpath = ".//input[@name='strict_search']")
    private CheckBoxBEM strictSearchCheckbox;

    @Name("Радиогруппа 'Показы в РСЯ'")
    @FindBy(xpath = ".//input[@name='search_or_net']")
    private RadioBEM platformOptionRadio;

    @Name("Радиогруппа 'Показы по ДРФ'")
    @FindBy(xpath = ".//input[@name='broad_match_flag']")
    private RadioBEM relevantPhraseShowsRadio;

    @Name("Радиогруппа 'Условия ретаргетинга'")
    @FindBy(xpath = ".//input[@name='retargetings']")
    private RadioBEM retargetingConditionsRadio;

    @Name("Селект стратегии")
    @FindBy(xpath = ".//select[@name='strategy']")
    private SelectBEM strategySelect;

    @Name("Кнопка 'Найти'")
    @FindBy(xpath = ".//button[@type='submit']")
    private Button searchButton;

    @Name("Список найденных id баннеров")
    @FindBy(css = "div.p-banners-search__banner-number")
    private List<WebElement> foundBannerIds;

    @Name("Список id кампаний найденных баннеров")
    @FindBy(xpath = ".//a[contains(@href, 'searchcid')]")
    private List<WebElement> foundCampaignIds;

    public void clickSearchButton() {
        searchButton.click();
    }

    public List<Long> getFoundIdsList() {
        List<Long> ids = new ArrayList<>();
        for (WebElement id : foundBannerIds) {
            for (String bid : id.getText().replaceAll("\\D-", "").split(",\n")) {
                ids.add(Long.parseLong(bid));
            }
        }
        return ids;
    }

    public List<Long> getFoundCampaignIdsList() {
        List<Long> ids = foundCampaignIds.stream().map(id -> Long.parseLong(id.getText())).collect(Collectors.toList());
        return ids;
    }

    public void fillParameters(SearchBannersInfoWeb bean) {
        fillRadio(bannerTypeRadio, bean.getBannerType(), RadioInputMethod.BY_VALUE);
        fillRadio(searchTypeRadio, bean.getBannersSearchTypeValue(), RadioInputMethod.BY_VALUE);
        fillRadio(platformOptionRadio, bean.getPlatformOptionValue(), RadioInputMethod.BY_VALUE);
        fillRadio(retargetingConditionsRadio, bean.getRetargetingConditionsValue(), RadioInputMethod.BY_VALUE);
        fillSelectWithPatrialMatch(strategySelect, bean.getStrategyValue(), SelectInputMethod.BY_VALUE);
        fillTextInput(searchTextInput, bean.getSearchText());
        setCheckboxState(activeOnlyCheckbox, bean.getSearchOnlyActive());
        setCheckboxState(groupCampCheckbox, bean.getGroupByCampaigns());
        setCheckboxState(currencyArchivedCampaignsCheckbox, bean.getOldNoCurrencyArchivedCampaigns());
        setCheckboxState(strictSearchCheckbox, bean.getStrictSearch());
    }
}