package ru.yandex.autotests.direct.web.pages.banners.blocks.edit;

import java.util.List;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static org.junit.Assert.assertThat;

/**
 * User: alexey-n
 * Date: 16.09.13
 * Time: 17:37
 */
@FindBy(xpath = ".//body")
public class AdjustPhraseBlock extends HtmlElement {

    @Name("Поле для ввода ключевого слова")
    @FindBy(xpath = ".//input[@type = 'text']")
    private TextInput keyWordInput;

    @Name("")
    @FindBy(xpath = ".//table[@id = 'list']//tr[3]//table//td[2]")
    private WebElement regions;

    @FindBy(xpath = ".//tr[@class = 'tlist']")
    public static class MinusPhraseRow extends HtmlElement {

        @Name("")
        @FindBy(xpath = ".//input")
        private CheckBox selectMinusPhrase;

        @Name("")
        @FindBy(xpath = ".//td[2]")
        private WebElement phraseLink;
    }

    List<MinusPhraseRow> minusPhraseRows;

    public void checkRegions(String region) {
        assertThat("регион не соответствует ожиданиям",
                regions.getText(), equalTo(region));
    }

    public void checkPhrase(String phrase) {
        assertThat("фраза в поле для ввода не соответствует ожиданиям",
                keyWordInput.getText(), equalTo(phrase));
        assertThat("таблица со списком минус слов не соответствует ожиданиям",
                minusPhraseRows, not(empty()));
    }
}
