package ru.yandex.autotests.direct.web.pages.banners.blocks.edit;

import java.util.ArrayList;
import java.util.List;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.banners.commons.SiteLinkInfoWeb;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;
import ru.yandex.qatools.htmlelements.element.Select;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillHrefWithScheme;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@FindBy(xpath = "//div[contains(@class, 'visible')]" +
        "//div[@class='b-popupa__content']/div[contains(@class, 'b-banner-sitelinks')]")
public class BannerSiteLinksPopupBlock extends HtmlElement implements IWebFrom<SiteLinkInfoWeb[]> {
    @Name("")
    @FindBy(xpath = ".//a[contains(@class, 'b-banner-preview__sitelink')]")
    private List<Link> previewLinks;

    @Name("")
    @FindBy(xpath = ".//span[contains(@class, 'b-banner-sitelinks__clear')]")
    private WebElement clearAllLink;

    @Name("Список названий ссылок")
    @FindBy(xpath = ".//tr[@class='b-banner-sitelinks__row-title']//input[contains(@class, 'title')]")
    private List<TextInput> linkTitlesList;

    @Name("Список ссылок")
    @FindBy(xpath = ".//tr[@class='b-banner-sitelinks__row-href']//input")
    private List<TextInput> linksList;

    @Name("Список протоколов ссылок")
    @FindBy(css = "select.b-banner-sitelinks__href-protocol")
    private List<Select> protocolList;

    @Name("")
    @FindBy(xpath = ".//span[contains(@class, 'sitelinks__action_type_save')]/input")
    private Button saveButton;

    @Name("")
    @FindBy(xpath = ".//span[contains(@class, 'close') or contains(@class, 'cancel')]/input")
    private Button cancelButton;

    public void clickSave() {
        saveButton.click();
    }

    public void clickOnClearAllLink() {
        clearAllLink.click();
    }

    @Override
    public void fillParameters(SiteLinkInfoWeb[] siteLinks) {
        if (siteLinks != null) {
            for (int i = 0; i < siteLinks.length; i++) {
                linkTitlesList.get(i).clear();
                linkTitlesList.get(i).sendKeys(siteLinks[i].getTitle());
                linksList.get(i).clear();
                inputHref(i, siteLinks[i].getHref());
            }
        }
    }

    @Override
    public void checkParameters(SiteLinkInfoWeb[] siteLinks) {
        if (siteLinks != null) {
            SiteLinkInfoWeb[] actualSiteLinks = getFormFieldsAccording(siteLinks);
            for (int i = 0; i < siteLinks.length; i++) {
                assertThat("неправильные параметры быстрых ссылок", actualSiteLinks[i], beanEquals(siteLinks[i]));
            }
        }
    }


    public void inputHref(int index, String href) {
        fillHrefWithScheme(linksList.get(index), protocolList.get(index), href, false);
    }

    public String getHref(int index) {
        return linksList.get(index).getText().equals("") ? "" :
                protocolList.get(index).getFirstSelectedOption().getText() + linksList.get(index).getText();
    }

    @Override
    public SiteLinkInfoWeb[] getFormFieldsAccording(SiteLinkInfoWeb[] expectedBean) {
        List<SiteLinkInfoWeb> result = new ArrayList<>();
        for (int i = 0; i < expectedBean.length; i++) {
            result.add(new SiteLinkInfoWeb(linkTitlesList.get(i).getText(),
                    getHref(i)));
        }
        cancelButton.click();
        return result.toArray(new SiteLinkInfoWeb[result.size()]);
    }

    public SiteLinkInfoWeb[] getFormFieldsAccording() {
        List<SiteLinkInfoWeb> result = new ArrayList<>();
        for (TextInput linkTitle : linkTitlesList) {
            if (!linkTitle.getText().isEmpty()) {
                result.add(new SiteLinkInfoWeb(linkTitle.getText(),
                        getHref(linkTitlesList.indexOf(linkTitle))));
            }
        }
        return result.toArray(new SiteLinkInfoWeb[result.size()]);
    }
}
