package ru.yandex.autotests.direct.web.pages.banners.blocks.edit;


import java.util.List;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.Link;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static org.junit.Assert.assertThat;

/**
 * User: alexey-n
 * Date: 16.09.13
 * Time: 17:37
 */
@FindBy(xpath = ".//body")
public class ChoosePhraseBlock extends HtmlElement {

    @Name("Поле для ввода ключевого слова")
    @FindBy(xpath = ".//input[@type = 'text']")
    private TextInput keyWordInput;

    @Name("ID регионов")
    @FindBy(xpath = ".//input[contains(@class, 'b-region-selector__geo')]")
    private WebElement regionIDs;

    @Name("")
    @FindBy(xpath = ".//table[@id = 'left-table']")
    List<PhraseRow> leftTablePhraseRow;

    @Name("")
    @FindBy(xpath = ".//table[@id = 'right-table']")
    List<PhraseRow> rightTablePhraseRow;

    @FindBy(xpath = ".//tr[@class = 'tlist']")
    public static class PhraseRow extends HtmlElement {

        @Name("Чекбокс фразы")
        @FindBy(xpath = ".//input")
        private CheckBox selectPhrase;

        @Name("Ссылка для фразы")
        @FindBy(xpath = ".//a")
        private Link phraseLink;
    }

    public void checkPhrases(String phrase) {
        assertThat("фраза в поле для ввода не соответствует ожиданиям",
                keyWordInput.getText(), equalTo(phrase));
        assertThat("таблица со списком фраз не соответствует ожиданиям",
                leftTablePhraseRow, not(empty()));
        assertThat("таблица со списком фраз не соответствует ожиданиям",
                rightTablePhraseRow, not(empty()));
    }

    public void checkRegions(String regions) {
        assertThat("регион не соответствует ожиданиям",
                regionIDs.getAttribute("value").replace(" ", ""), equalTo(regions));
    }
}
