package ru.yandex.autotests.direct.web.pages.banners.blocks.edit;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@FindBy(xpath = ".//div[contains(@class, 'retargeting__condition ')]")
public class RetargetingConditionRow extends HtmlElement {
    @Name("Кнопка удаления условия")
    @FindBy(xpath = ".//span[contains(@class, 'condition-del')]")
    private WebElement deleteButton;

    @Name("Номер условия")
    @FindBy(xpath = ".//span[contains(@class, 'num')]")
    private WebElement conditionNumber;

    @Name("Название условия")
    @FindBy(xpath = ".//span[contains(@class, 'label') and contains(@class, 'b-pseudo-link')]")
    private WebElement conditionName;

    public void clickDelete() {
        deleteButton.click();
    }

    public void clickOnName() {
        conditionName.click();
    }

    public String getConditionNameText() {
        return conditionName.getText();
    }
}
