package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import java.util.LinkedList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.SelectInputMethod;
import ru.yandex.autotests.direct.web.objects.banners.commons.ContactInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.autotests.direct.web.webelements.bem.TimePeriodInputBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Select;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.OperationSystemUtils.sleep;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillSelect;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;
import static ru.yandex.qatools.htmlelements.matchers.WrapsElementMatchers.exists;


/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 30.05.14
 */
@FindBy(xpath = ".//div[contains(@class, 'b-banner-vcard ') or contains(@class, 'b-form-vcard ') ]")
public class AddressAndPhoneBlockBEM extends ExtendedHtmlElement implements IWebFrom<ContactInfoWeb> {
    private static final String NEW_OGRN_TEXT = "-- новый --";

    @Name("Ссылка 'очистить контактную информацию'")
    @FindBy(xpath = ".//span[contains(@class, 'b-form-vcard__link_action_clear')]")
    private WebElement clearAllLink;

    @Name("Поле ввода страны")
    @FindBy(xpath = ".//span[contains(@class, 'b-form-vcard__input_name_country')]//input")
    private TextInput country;

    @Name("Поле ввода города")
    @FindBy(xpath = ".//span[contains(@class, 'b-form-vcard__input_name_city')]//input")
    private TextInput city;

    @Name("Поле ввода кода страны")
    @FindBy(xpath = ".//span[contains(@class, 'b-form-vcard__input_name_phone-code-country')]//input")
    private TextInput countryCode;

    @Name("Поле ввода кода города")
    @FindBy(xpath = ".//span[contains(@class, 'b-form-vcard__input_name_phone-code-city')]//input")
    private TextInput cityCode;

    @Name("Поле ввода номера телефона")
    @FindBy(xpath = ".//span[contains(@class, 'b-form-vcard__input_name_phone-number')]//input")
    private TextInput phone;

    @Name("Поле ввода добавочного номера телефона")
    @FindBy(xpath = ".//span[contains(@class, 'b-form-vcard__input_name_phone-short')]//input")
    private TextInput phoneExt;

    @Name("Поле ввода имени компании")
    @FindBy(xpath = ".//input[contains(@name, 'name-') or contains(@name, 'ci_name') or @name='name']")
    private TextInput companyName;

    @Name("Поле ввода контактного лица")
    @FindBy(xpath = ".//input[contains(@name, 'contactperson')]")
    private TextInput contactPerson;

    private List<TimePeriodInputBEM> workingTimeList;

    @Name("Поле ввода улицы")
    @FindBy(xpath = ".//span[contains(@class, 'street')]//input")
    private TextInput street;

    @Name("Поле ввода номера дома")
    @FindBy(xpath = ".//span[contains(@class, 'house')]//input")
    private TextInput house;

    @Name("Поле ввода номера строения")
    @FindBy(xpath = ".//span[contains(@class, 'build')]//input")
    private TextInput build;

    @Name("Поле ввода номера офиса/квартиры")
    @FindBy(xpath = ".//input[contains(@name, 'apart')]")
    private TextInput apart;

    @Name("Поле ввода email")
    @FindBy(xpath = ".//input[contains(@name, 'contact_email')]")
    private TextInput contactEmail;

    @Name("Селект IM")
    @FindBy(xpath = ".//select[contains(@name, 'im_client')]")
    private SelectBEM IMClient;

    @Name("Поле ввода логина IM")
    @FindBy(xpath = ".//input[contains(@name, 'im_login')]")
    private TextInput IMLogin;

    @Name("Поле ввода дополнительной информации")
    @FindBy(xpath = ".//textarea[contains(@name, 'extra_message')]")
    private TextInput extraMessage;

    @Name("Поле ввода ОГРН")
    @FindBy(xpath = ".//input[contains(@name, 'ogrn')]")
    private TextInput OGRNTextInput;

    @Name("Селект ОГРН")
    @FindBy(xpath = ".//span[contains(@class, 'b-form-vcard__input_name_ogrn')]/select")
    private SelectBEM OGRNSelect;

    public String getPhoneNumber() {
        return phone.getText().replace("-", "");
    }

    public String getWorkTime() {
        LinkedList<String> valuesList = new LinkedList<>();
        for (TimePeriodInputBEM workingTime : workingTimeList) {
            valuesList.add(workingTime.getWorkTime());
        }
        return StringUtils.join(valuesList, ";").replace("00", "0");
    }

    private void fillWorkTime(String period) {
        if (period == null)
            return;
        String[] timeValues = period.split(";");
        addWorkingHours(timeValues.length / 6);
        int timeValueCounter = 1;
        List<String> timeValueLine = new LinkedList<>();
        for (String timeValue : timeValues) {
            timeValueLine.add(timeValue);
            if (timeValueCounter % 6 == 0) {
                workingTimeList.get(timeValueCounter / 6 - 1).fillWorkTime(StringUtils.join(timeValueLine, ";"));
                timeValueLine.clear();
            }
            timeValueCounter++;
        }
    }

    private void addWorkingHours(int count) {
        if (workingTimeList.size() == count)
            return;
        if (workingTimeList.size() > count) {
            for (int i = workingTimeList.size() - 1; i > count - 1; i--) {
                workingTimeList.get(i).clickOnRemoveWorkingTimeButton();
            }
        }
        if (workingTimeList.size() < count) {
            for (int i = workingTimeList.size() - 1; i < count - 1; i++) {
                workingTimeList.get(i).clickOnAddWorkingTimeButton();
            }
        }
    }

    public void fillStreet(String street) {
        fillTextInput(this.street, street);
        sleep(3000);
    }

    @Override
    public void fillParameters(ContactInfoWeb bean) {
        fillTextInput(country, bean.getCountry());
        fillTextInput(city, bean.getCity());
        fillTextInput(countryCode, bean.getCountryCode());
        fillTextInput(cityCode, bean.getCityCode());
        fillTextInput(phone, bean.getPhone());
        fillTextInput(phoneExt, bean.getPhoneExt());
        fillTextInput(companyName, bean.getCompanyName());
        fillTextInput(contactPerson, bean.getContactPerson());
        fillWorkTime(bean.getWorkTime());
        fillStreet(bean.getStreet());
        fillTextInput(house, bean.getHouse());
        fillTextInput(build, bean.getBuild());
        fillTextInput(apart, bean.getApart());
        fillTextInput(contactEmail, bean.getContactEmail());
        fillSelect(IMClient, bean.getIMClient(), SelectInputMethod.BY_VALUE);
        fillTextInput(IMLogin, bean.getIMLogin());
        fillTextInput(extraMessage, bean.getExtraMessage());
        fillOGRN(bean.getOGRN());

    }

    private void fillOGRN(String ogrn) {
        if (ogrn == null) {
            return;
        }
        if (exists().matches(OGRNSelect) && OGRNSelect.isDisplayed()) {
            for (WebElement ogrnOption : OGRNSelect.getOptions()) {
                if (ogrnOption.getAttribute("text").equals(ogrn)) {
                    OGRNSelect.selectByVisibleText(ogrn);
                    return;
                }
            }
            OGRNSelect.selectByVisibleText(NEW_OGRN_TEXT);
        }
        fillTextInput(OGRNTextInput, ogrn);
    }

    public String getOGRN() {
        if (exists().matches(OGRNSelect) && OGRNSelect.isDisplayed()
                && !OGRNSelect.getFirstSelectedOption().getAttribute("text").equals(NEW_OGRN_TEXT)) {
            return OGRNSelect.getFirstSelectedOption().getAttribute("text");
        }
        return OGRNTextInput.getText();
    }

    @Override
    public void checkParameters(ContactInfoWeb expectedBean) {
        if (expectedBean == null) {
            return;
        }
        assertThat("неверные параметры контактной информации",
                getFormFieldsAccording(expectedBean), beanEquals(expectedBean));
    }

    @Override
    public ContactInfoWeb getFormFieldsAccording(ContactInfoWeb expectedBean) {
        return inAccordanceWith(expectedBean).forNew(ContactInfoWeb.class)
                .set("country", country, on(TextInput.class).getText())
                .set("city", city, on(TextInput.class).getText())
                .set("countryCode", countryCode, on(TextInput.class).getText())
                .set("cityCode", cityCode, on(TextInput.class).getText())
                .set("phone", this, on(AddressAndPhoneBlockBEM.class).getPhoneNumber())
                .set("phoneExt", phoneExt, on(TextInput.class).getText())
                .set("companyName", companyName, on(TextInput.class).getText())
                .set("contactPerson", contactPerson, on(TextInput.class).getText())
                .set("workTime", this, on(AddressAndPhoneBlockBEM.class).getWorkTime())
                .set("street", street, on(TextInput.class).getText())
                .set("house", house, on(TextInput.class).getText())
                .set("build", build, on(TextInput.class).getText())
                .set("apart", apart, on(TextInput.class).getText())
                .set("contactEmail", contactEmail, on(TextInput.class).getText())
                .set("IMClient", IMClient,
                        on(Select.class).getFirstSelectedOption().getAttribute("value"))
                .set("IMLogin", IMLogin, on(TextInput.class).getText())
                .set("extraMessage", extraMessage,
                        on(TextInput.class).getWrappedElement().getAttribute("value"))
                .set("OGRN", this, on(AddressAndPhoneBlockBEM.class).getOGRN())
                .getActualBean();
    }

    public boolean hasEmptyRequiredField() {
        return this.country.getText().equals("") || this.city.getText().equals("") ||
                this.countryCode.getText().equals("") || this.cityCode.getText().equals("") ||
                this.phone.getText().equals("") || this.companyName.getText().equals("");
    }
}
