package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.BannerPreviewType;
import ru.yandex.autotests.direct.web.data.RadioInputMethod;
import ru.yandex.autotests.direct.web.data.banners.DirectBannerType;
import ru.yandex.autotests.direct.web.data.banners.ImageLoadType;
import ru.yandex.autotests.direct.web.data.textresources.EditBannerResource;
import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.ContactInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.SiteLinkInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.TurboLandingInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.VideoInfoWeb;
import ru.yandex.autotests.direct.web.objects.imagead.ImageAdWeb;
import ru.yandex.autotests.direct.web.pages.DirectCommonPage;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.steps.UserSteps;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.autotests.direct.web.util.StringHelper;
import ru.yandex.autotests.direct.web.util.WebDriverUtils;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.ImageAdRadioBEM;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.autotests.direct.web.webelements.bem.TextAreaBEM;
import ru.yandex.autotests.direct.web.webelements.bem.TumblerBEM;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static ch.lambdaj.Lambda.on;
import static com.google.common.collect.Iterables.getLast;
import static java.util.Objects.isNull;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillHrefWithScheme;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillRadio;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.isExists;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanHelper.hasNotNullProperty;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.hasText;

@FindBy(xpath = ".//div[contains(@class, 'b-edit-banner2 ')]")
public class BannerBlockBEM extends ExtendedHtmlElement implements IWebFrom<BannerInfoWeb> {

    private ImagePopupSteps onImagePopup() {
        return BaseSteps.getInstance(ImagePopupSteps.class, config);
    }

    public final static String NEW_BANNER_ID = "new";

    //region Fields

    @Name("Селект выбора протокола URL")
    @FindBy(css = "span.b-href-control__protocol select")
    private SelectBEM hrefProtocolSelect;

    @Name("Ссылка на сайт")
    @FindBy(xpath = ".//span[contains(@class, 'b-href-control')]//input")
    private TextInput href;

    @Name("Ссылка показать/скрыть домен")
    @FindBy(xpath = ".//button[contains(@class, 'b-banner-href__domain-switcher')]")
    private Button domainStrict;

    @Name("Домен")
    @FindBy(xpath = ".//span[contains(@class, 'b-banner-href__domain-input')]//input")
    private TextInput domain;

    @Name("Заголовок")
    @FindBy(xpath = ".//div[contains(@class,'b-edit-banner2__title')]//input")
    private TextInput bannerTitle;

    @Name("Заголовок 2")
    @FindBy(xpath = ".//input[@name='title_extension']")
    private TextInput bannerTitleExtension;

    @Name("Текст объявления")
    @FindBy(xpath = ".//span[contains(@class, 'b-edit-banner2') and contains(@class, 'model-field')]//textarea")
    private TextAreaBEM bannerBodyText;

    @Name("Открыть попап быстрых ссылок")
    @FindBy(xpath = ".//div[contains(@class, 'b-banner-sitelinks__outboard')]//button")
    private WebElement addLinksButton;

    @Name("Текст быстрых ссылок")
    @FindBy(xpath = ".//div[@class='b-banner-sitelinks__titles']")
    private WebElement siteLinksText;

    @Name("Кнопка изменить изображение")
    @FindBy(xpath = ".//div[contains(@class, 'b-banner-pic__outboard')]//button")
    private Button editImageButton;

    @Name("Кнопка добавления текстовых дополнений")
    @FindBy(css = ".b-banner-callouts button")
    private WebElement addCalloutsButton;

    private CalloutsPopup calloutsPopup;

    @Name("Текст дополнений")
    @FindBy(css = ".b-banner-callouts__outcome")
    private WebElement calloutsText;

    @Name("Выключатель адреса и телефона")
    @FindBy(xpath = ".//span[contains(@class, 'b-vcard-control__tumbler')]//input")
    private TumblerBEM contactInfoSwitcher;

    @Name("Чекбокс мобильного объявления")
    @FindBy(xpath = ".//input[@name='banner_type']")
    private CheckBoxBEM bannerIsMobileType;

    @Name("Отображаемая ссылка")
    @FindBy(xpath = ".//div[contains(@class, 'b-edit-banner2__display-link-control')]//input")
    private TextInput bannerDisplayHref;

    @Name("Переключатель типа баннера")
    @FindBy(xpath = ".//div[contains(@class,'b-edit-banner2__ad-type')]//input")
    protected ImageAdRadioBEM bannerType;

    @Name("Выбранный тип баннера")
    @FindBy(xpath = ".//div[@class='b-edit-banner2__text-wrap']")
    private WebElement selectedBannerType;

    @Name("Кнопка добавления/изменения креатива в объявлении")
    @FindBy(xpath = ".//div[contains(@class, 'b-image-add-loader')]//button")
    private Button editImageAdButton;

    @Name("Картинка из графического объявления")
    @FindBy(xpath = ".//div[contains(@class,'b-image-add-loader__sign-content')]")
    private WebElement imageAdPicture;

    @Name("Переключатель вкладки превью")
    @FindBy(xpath = ".//div[contains(@class,'b-banner-preview-filter2')]//input")
    protected RadioBEM previewType;

    @Name("Превью объявления")
    @FindBy(xpath = ".//div[contains(@class,'b-edit-banner2__banner-viewer')]")
    private WebElement bannerPreview;

    @Name("Предупреждение о проверке ссылки")
    @FindBy(xpath = "//div[contains(@class, 'b-banner-preview2-warnings__dynamic')]")
    private WebElement linkDynamicWarning;

    @Name("Метка 'объявление'")
    @FindBy(xpath = ".//div[@class='b-edit-banner2__label-text']")
    private WebElement bannerLabel;

    @Name("Блок турболендинга")
    private TurboLandingBlockBEM turboLandingBlockBEM;

    @Name("Блок видеодополнения")
    private VideoBlockBEM videoBlockBEM;

    @Name("Блок видеокреатива")
    private VideoCreativeBlockBem videoCreativeBlockBem;

    @Name("Селект изменить видео")
    @FindBy(xpath = ".//div[contains(@class, 'b-video-creative-selector')]//button")
    private Button editVideoSelect;

    @Name("Удалить видео")
    @FindBy(css =".b-video-extension__delete")
    private Button deleteVideoButton;

    private DirectCommonPage commonPage;

    private void removeVideo() {
        if (deleteVideoButton.isDisplayed()) {
            deleteVideoButton.click();
        } else {
            throw new DirectWebError("Отсутствует добавленное видео!");
        }
    }

    public void fillVideo(BannerInfoWeb bannerInfoWeb) {
        if (bannerInfoWeb.getBannerType() == DirectBannerType.VIDEO) {
            fillVideoBannerAndSave(bannerInfoWeb.getVideo());
        }
        else {
            fillVideoAdditionAndSave(bannerInfoWeb.getVideo());
        }
    }

    public void fillVideoAdditionAndSave(VideoInfoWeb videoInfoWeb) {
        if (videoInfoWeb == null) {
            return;
        }
        if (videoInfoWeb == videoInfoWeb.DISABLED_VIDEO) {
            removeVideo();
            config.getDriver().switchTo().defaultContent();
            return;
        }
        if (videoInfoWeb.getVideoName() != null) {
            editVideoSelect.click();
            waitForElement(videoBlockBEM, 3, WebElementMatchers.isDisplayed());
            videoBlockBEM.setConfig(config);
            videoBlockBEM.fillVideo(videoInfoWeb);
        }
    }

    public BannerSiteLinksPopupBlockBEM getLinksPopupBlock() {
        linksPopupBlock.setConfig(config);
        return linksPopupBlock;
    }

    private BannerSiteLinksPopupBlockBEM linksPopupBlock;

    private AddressAndPhoneBlockBEM addressAndPhoneBlock;

    //endregion

    //region Actions

    private void contactInfoSetEnabled(boolean enabled) {
        if (enabled) {
            contactInfoSwitcher.select();
        } else {
            contactInfoSwitcher.deselect();
        }
    }

    private void inputTitle(String title) {
        if (title == null) {
            return;
        }
        bannerTitle.getWrappedElement().click();
        bannerTitle.clear();
        bannerTitle.sendKeys(title);
    }

    private void inputTitleExtension(String titleExtension) {
        if (titleExtension == null) {
            return;
        }
        if (titleExtension.isEmpty()) {
            //HACK: click on clear icon if title is empty, keyup, change, focus, blur events produce no effect
            bannerTitleExtension.getWrappedElement()
                    .findElement(By.xpath("./../span[contains(@class, 'input__clear')]"))
                    .click();
            return;
        }
        bannerTitleExtension.clear();
        bannerTitleExtension.sendKeys(titleExtension);
    }

    private void inputDisplayHref(String dispHref) {
        if (dispHref == null) {
            return;
        }
        fillTextInput(bannerDisplayHref, dispHref);
    }

    private void inputText(String text) {
        if (text == null) {
            return;
        }
        bannerBodyText.click();
        bannerBodyText.clear();
        bannerBodyText.sendKeys(text);
    }

    private void inputHref(String text) {
        if (text == null) {
            return;
        }
        href.getWrappedElement().click();
        fillHrefWithScheme(href, hrefProtocolSelect, text, false);
        new JavaScriptActions(config).fireKeyUpEvent(href.getWrappedElement());
        new JavaScriptActions(config).fireChangeEvent(href.getWrappedElement());
        new JavaScriptActions(config).fireBlurEvent(href.getWrappedElement());
    }

    private void fillQuickLinks(SiteLinkInfoWeb[] siteLinks) {
        if (siteLinks == null) {
            return;
        }
        new JavaScriptActions(config).scrollToElement(addLinksButton);
        List<WebElement> hideElements = UserSteps.getInstance(UserSteps.class, config).page(DirectCommonPage.class).getGroupFloater();
        new JavaScriptActions(config).hideElements(hideElements);

        addLinksButton.click();
        getLinksPopupBlock().fillParameters(siteLinks);
        takeScreenshot();
        getLinksPopupBlock().clickSave();
    }

    private void fillCallouts(List<String> callouts) {
        if (isNull(callouts)) {
            return;
        }
        addCalloutsButton.click();
        calloutsPopup.addCallouts(callouts);
        takeScreenshot();
        calloutsPopup.clickSave();
    }

    private void fillContactInfo(ContactInfoWeb contactInfo) {
        if (contactInfo == null) {
            return;
        }
        if (hasNotNullProperty(contactInfo)) {
            contactInfoSetEnabled(true);
            getAddressAndPhoneBlock().fillParameters(contactInfo);
        } else {
            contactInfoSetEnabled(false);
        }
    }

    private void fillBannerIsMobileType(Boolean status) {
        if (status == null) {
            return;
        }
        setCheckboxState(bannerIsMobileType, status);
    }

    public void checkSiteLinks(SiteLinkInfoWeb[] siteLinks) {
        if (siteLinks == null) {
            return;
        }
        new JavaScriptActions(config).scrollToElement(addLinksButton);
        List<WebElement> hideElements = UserSteps.getInstance(UserSteps.class, config).page(DirectCommonPage.class).getGroupFloater();
        new JavaScriptActions(config).hideElements(hideElements);

        addLinksButton.click();
        getLinksPopupBlock().checkParameters(siteLinks);
    }

    public void checkContactInfo(ContactInfoWeb contactInfo) {
        if (contactInfo == null) {
            return;
        }
        contactInfoSetEnabled(true);
        getAddressAndPhoneBlock().checkParameters(contactInfo);
    }

    public void checkImageOnPopup(Matcher matcher) {
        editImageButton.click();
        onImagePopup().checkImage(matcher);
    }

    public void checkCallouts(List<String> callouts) {
        if (isNull(callouts)) {
            return;
        }
        List<String> calloutsOnPage = getCallouts();
        assertThat("уточнения соответствуют ожидаемым", calloutsOnPage,
                containsInAnyOrder(callouts.toArray(new String[callouts.size()])));
    }

    public void checkImageAdPicture(ImageAdWeb imageAd) {
        if (imageAd == null) {
            return;
        }
        String imageAdOnPage = getImageAd().getImageAdPictureName();
        assertThat("картинка соответствует ожиданиям", imageAdOnPage, equalTo(imageAd.getImageAdPictureName()));
    }

    public void checkIsBannerMobile(Boolean state) {
        if (state == null) {
            return;
        }
        Boolean stateOnPage = getBannerIsMobileType();
        assertThat("баннер является мобильным", stateOnPage, equalTo(state));
    }

    public void checkMobileCheckboxShouldBe(Matcher<TypifiedElement> matcher) {
        assertThat("чек-бокс мобильного объявления в состоянии", bannerIsMobileType, matcher);
    }

    public void checkDisplayHref(String dispHref) {
        if (dispHref == null) {
            return;
        }
        assertThat("отображаемая ссылка соответствует ожидаемой", getDisplayHref(), equalTo(dispHref));
    }

    public void checkBannerType(DirectBannerType type) {
        if (type == null) {
            return;
        }
        assertThat("тип баннера соответствует ожидаемому", getBannerType(), equalTo(type));
    }

    public void fillBannerType(DirectBannerType bannersType) {
        if (bannersType == null) {
            return;
        }
        bannerType.selectByValue(bannersType.toString());
    }

    public TurboLandingInfoWeb getTurboLanding() {
        return getTurboLandingBlockBEM().getSelectedTurboLanding();
    }

    public void fillTurboLanding(TurboLandingInfoWeb turboLandingInfoWeb) {
        getTurboLandingBlockBEM().fillTurboLanding(turboLandingInfoWeb);
    }

    public void fillImageAndSave(ImageLoadType type, String img) {
        editImageButton.click();
        onImagePopup().loadImage(type, img);
    }

    public void fillImageAdPictureAndSave(ImageAdWeb imgAd) {
        if (imgAd == null) {
            return;
        }
        editImageAdButton.click();
        onImagePopup().loadAdImage(imgAd);
    }

    public void fillVideoBannerAndSave(VideoInfoWeb videoInfoWeb) {
        if (videoInfoWeb == null) {
            return;
        }
        editImageAdButton.click();
        waitForElement(videoCreativeBlockBem, 3, WebElementMatchers.isDisplayed());
        videoCreativeBlockBem.setConfig(config);
        videoCreativeBlockBem.loadVideoFromGallery(videoInfoWeb);
    }

    public void removeImg() {
        editImageButton.click();
        onImagePopup().removeImg();
    }

    @Override
    public void fillParameters(BannerInfoWeb bannerInfo) {
        fillBannerType(bannerInfo.getBannerType());
        inputTitle(bannerInfo.getTitle());
        inputTitleExtension(bannerInfo.getTitleExtension());
        inputText(bannerInfo.getText());
        inputHref(bannerInfo.getHref());
        inputDisplayHref(bannerInfo.getDisplayHref());
        fillQuickLinks(bannerInfo.getSitelinks());
        fillCallouts(bannerInfo.getCallouts());
        fillContactInfo(bannerInfo.getContactInfo());
        fillBannerIsMobileType(bannerInfo.getIsMobileBannerType());
        fillImageAdPictureAndSave(bannerInfo.getImageAd());
        fillTurboLanding(bannerInfo.getTurboLanding());
        fillVideo(bannerInfo);
        waitForElement(linkDynamicWarning, 5, not(hasText(EditBannerResource.HREF_CHECK_IN_PROGRESS.toString())));
    }

    @Override
    public void checkParameters(BannerInfoWeb expectedBean) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BannerInfoWeb getFormFieldsAccording(BannerInfoWeb expectedBean) {
        BannerInfoWeb bannerInfo = inAccordanceWith(expectedBean).forNew(BannerInfoWeb.class)
                .set("bannerType", this, on(BannerBlockBEM.class).getBannerType())
                .set("title", bannerTitle, on(TextInput.class).getText())
                .set("titleExtension", bannerTitleExtension, on(TextInput.class).getText())
                .set("text", bannerBodyText, on(TextAreaBEM.class).getText())
                .set("href", this, on(BannerBlockBEM.class).getHref())
                .set("domain", this, on(BannerBlockBEM.class).getDomainName())
                .set("displayHref", this, on(BannerBlockBEM.class).getDisplayHref())
                .set("callouts", this, on(BannerBlockBEM.class).getCallouts())
                .set("isMobileBannerType", this, on(BannerBlockBEM.class).getBannerIsMobileType())
                .set("imageAd", this, on(BannerBlockBEM.class).getImageAd())
                .set("turboLanding", this, on(BannerBlockBEM.class).getTurboLanding())
                .getActualBean();
        bannerInfo.setBannerId(getBannerId());
        bannerInfo.setCampaignId(expectedBean.getCampaignId());
        return bannerInfo;
    }

    //endregion

    //region Field getters

    private AddressAndPhoneBlockBEM getAddressAndPhoneBlock() {
        addressAndPhoneBlock.setConfig(config);
        return addressAndPhoneBlock;
    }

    private VideoBlockBEM getVideoBlockBEM() {
        videoBlockBEM.setConfig(config);
        return videoBlockBEM;
    }

    private TurboLandingBlockBEM getTurboLandingBlockBEM() {
        turboLandingBlockBEM.setConfig(config);
        return turboLandingBlockBEM;
    }

    public String getDomainName() {
        domainStrict.click();
        return domain.getText();
    }

    public List<String> getCallouts() {
        if (calloutsText.getText().isEmpty()) {
            return Collections.emptyList();
        }

        return Arrays.asList(calloutsText.getText().split(", "));
    }

    public String getHref() {
        return href.getText().equals("") ? "" :
                hrefProtocolSelect.getSelectedText() + href.getText();
    }

    public String getDisplayHref() {
        return bannerDisplayHref.getText();
    }

    public Long getBannerId() {
        return getLast(StringHelper.getNumericDataFromText(bannerLabel.getAttribute("id")));
    }

    public Boolean getBannerIsMobileType() {
        if (bannerIsMobileType.isDisplayed()) {
            return bannerIsMobileType.isSelected();
        } else {
            return false;
        }
    }

    public DirectBannerType getBannerType() {
        if (WebElementMatchers.exists().matches(selectedBannerType)) {
            return DirectBannerType.getDirectBannerTypeByTextDescription(selectedBannerType.getText());
        }
        return DirectBannerType.getDirectBannerTypeByValue(bannerType.getSelectedValue());
    }

    public ImageAdWeb getImageAd() {
        ImageAdWeb imageAd = new ImageAdWeb();
        imageAd.setImageAdPictureName(imageAdPicture.getText());
        return imageAd;
    }

    public void fillLinks(String link, SiteLinkInfoWeb[] sitelinks) {
        inputHref(link);
        fillQuickLinks(sitelinks);
    }

    public void clickBannerPreviewType(BannerPreviewType prevType) {
        if (previewType == null) {
            return;
        }
        fillRadio(previewType, prevType.toString(), RadioInputMethod.BY_VALUE);
    }

    public WebElement getBannerPreview() {
        return bannerPreview;
    }

    public void openImagePopop() {
        editImageButton.click();
    }

    public void openSiteLinksPopop() {
        addLinksButton.click();
    }

    public void openCalloutsPopop() {
        addCalloutsButton.click();
    }

    //endregion
}
