package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import java.util.ArrayList;
import java.util.List;

import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.banners.commons.SiteLinkInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.TurboLandingInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.autotests.direct.web.webelements.bem.TextAreaBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.Link;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillHrefWithScheme;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.getVisibleElement;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.isExists;

@FindBy(xpath = "//div[contains(@class, 'visible')]" +
        "/div[contains(@class, 'popup__content')]" +
        "[.//div[contains(@class, 'b-sitelinks-selector')]]")
public class BannerSiteLinksPopupBlockBEM extends ExtendedHtmlElement implements IWebFrom<SiteLinkInfoWeb[]> {

    @Name("Предпросмотр быстрых ссылок")
    @FindBy(xpath = ".//a[contains(@class, 'b-banner-preview__sitelink')]")
    private List<Link> previewLinks;

    @Name("Очистить все")
    @FindBy(xpath = ".//span[contains(@class, 'b-sitelinks-selector__clear')]")
    private WebElement clearAllLink;

    @Name("Список подсказок к названиям ссылок")
    @FindBy(xpath = ".//input[contains(@name, 'sitelinks-title')]/../../label")
    private List<WebElement> linkTitleLabelsList;

    @Name("Список подсказок к ссылкам")
    @FindBy(xpath = ".//span[contains(@class, 'b-sitelinks-selector__href')]//label[contains(@class, 'input__hint-manual')]")
    private List<WebElement> linkLabelsList;

    @Name("Список названий ссылок")
    @FindBy(xpath = ".//input[contains(@name, 'sitelinks-title')]")
    private List<TextInput> linkTitlesList;

    @Name("Список ссылок")
    @FindBy(xpath = ".//textarea[contains(@name, 'sitelinks-href')]")
    private List<TextAreaBEM> linksList;

    @Name("Список протоколов ссылок")
    @FindBy(xpath = ".//select[contains(@name, 'sitelinks-url_protocol')]")
    private List<SelectBEM> protocolList;

    @Name("Список турболендинов")
    private List<TurboLandingBlockBEM> turbolandingsList;

    @Name("Сохранить")
    @FindBy(xpath = ".//button[contains(@class, 'b-sitelinks-selector__accept-button')]")
    private Button saveButton;

    @Name("Отмена")
    @FindBy(css = "button.b-sitelinks-selector__decline-button")
    private Button cancelButton;

    public void clickSave() {
        saveButton.click();
    }

    public void clickOnClearAllLink() {
        clearAllLink.click();
    }

    @Override
    public void fillParameters(SiteLinkInfoWeb[] siteLinks) {
        if (siteLinks != null) {
            for (int i = 0; i < siteLinks.length; i++) {
                new JavaScriptActions(config).scrollToElement(linkTitlesList.get(i).getWrappedElement());
                if (siteLinks[i].getTitle() != null) {
                    linkTitlesList.get(i).getWrappedElement().click();
                    fillTextInput(linkTitlesList.get(i), siteLinks[i].getTitle());
                }
                if (siteLinks[i].getHref() != null) {
                    linksList.get(i).getWrappedElement().click();
                    linksList.get(i).clear();
                    inputHref(i, siteLinks[i].getHref());
                }
                if(siteLinks[i].getTurboLanding() != null) {
                    getTurboLandingBlockBEM(turbolandingsList.get(i)).fillTurboLanding(siteLinks[i].getTurboLanding());
                }
            }
        }
    }

    public void inputHref(int index, String href) {
        fillHrefWithScheme(linksList.get(index), protocolList.get(index), href, false);
    }

    public String getHref(int index) {
        new JavaScriptActions(config).scrollToElement(linksList.get(index).getWrappedElement());
        return linksList.get(index).getText().equals("") ? "" :
                protocolList.get(index).getSelectedText() + linksList.get(index).getText();
    }

    @Override
    public void checkParameters(SiteLinkInfoWeb[] siteLinks) {
        if (siteLinks != null) {
            SiteLinkInfoWeb[] actualSiteLinks = getFormFieldsAccording(siteLinks);
            for (int i = 0; i < siteLinks.length; i++) {
                assertThat("неправильные параметры быстрых ссылок", actualSiteLinks[i], beanEquals(siteLinks[i]));
            }
        }
    }

    @Override
    public SiteLinkInfoWeb[] getFormFieldsAccording(SiteLinkInfoWeb[] expectedBean) {
        List<SiteLinkInfoWeb> result = new ArrayList<>();
        for (int i = 0; i < expectedBean.length; i++) {
            //TODO: подумать как убрать эту наработку
            //нужно для проверки подсказок в полях
            String href = getHref(i);
            if (href.equals("") && linkLabelsList.size() > i) {
                href = linkLabelsList.get(i).getText();
            }
            String title = linkTitlesList.get(i).getText();
            if (title.equals("") && linkTitleLabelsList.size() > i) {
                title = linkTitleLabelsList.get(i).getText();
            }
            TurboLandingInfoWeb turboLanding = null;
            if (expectedBean[i].getTurboLanding() != null) {
                turboLanding = getTurboLandingBlockBEM(turbolandingsList.get(i)).getSelectedTurboLanding();
            }
            result.add(new SiteLinkInfoWeb(title, href, turboLanding));
        }
        if (isExists(cancelButton)) {
            cancelButton.click();
        }
        return result.toArray(new SiteLinkInfoWeb[result.size()]);
    }


    private TurboLandingBlockBEM getTurboLandingBlockBEM(TurboLandingBlockBEM turboLandingBlockBEM) {
        turboLandingBlockBEM.setConfig(config);
        return turboLandingBlockBEM;
    }
}
