package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

/*
* todo javadoc
*/

import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.matchers.common.IsElementDisplayedMatcher;

import static com.google.common.base.Strings.isNullOrEmpty;
import static java.util.stream.Collectors.toList;
import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.OperationSystemUtils.sleep;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;

@FindBy(xpath = "//div[contains(@class, 'popup__content')][.//*[contains(@class, 'b-banner-callouts')]]")
@Name("Попап с текстовыми дополнениями")
public class CalloutsPopup extends ExtendedHtmlElement {

    @FindBy(xpath = ".//button[contains(@class, 'b-banner-callouts-popup__save')]")
    private Button saveButton;

    @FindBy(xpath = ".//button[contains(@class, 'b-banner-callouts-popup__cancel')]")
    private Button cancelButton;

    @FindBy(xpath = ".//*[contains(@class, 'b-callouts-selector__search-add-input')]//input")
    private TextInput newCalloutInput;

    @FindBy(css = "button.b-callouts-selector__new-item-button")
    private Button addNewCalloutButton;

    @FindBy(css = ".b-callouts-selector__clear-all")
    private WebElement clearAllLink;

    @FindBy(css = ".b-callouts-selector-item__text")
    private List<WebElement> selectedCalloutsList;

    @FindBy(xpath = "//div[contains(@class, 'b-callouts-selector__loader-spin')]")
    private WebElement spinLoader;

    public void clickSave() {
        saveButton.click();
    }

    public WebElement getSpinLoader () {
        return spinLoader;
    }

    public void waitForSpinLoader(Matcher<WebElement> matcher) {
        waitForElement(getSpinLoader(), 1, matcher);
    }

    public void addCallouts(List<String> callouts) {
        waitForSpinLoader(not(IsElementDisplayedMatcher.isDisplayed()));
        if (clearAllLink.isDisplayed())
            clearAllLink.click();
        for (String callout : callouts) {
            addNewCallout(callout);
        }
    }

    public void addNewCallout(String callout) {
        if (isNullOrEmpty(callout)) {
            return;
        }
        fillTextInput(newCalloutInput, callout);
        addNewCalloutButton.click();
        waitForSelection(callout);
    }

    public void waitForSelection(String callout) {
        for (int i = 0; i < 10; i++) {
            if (hasItem(callout).matches(getSelectedCallouts())) {
                break;
            }
            sleep(1000);
        }
    }

    public List<String> getSelectedCallouts() {
        return selectedCalloutsList.stream()
                .map(WebElement::getText)
                .collect(toList());
    }

}
