package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;


import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.objects.banners.CpmBannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.imagead.ImageAdWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.StringHelper;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static ch.lambdaj.Lambda.on;
import static com.google.common.collect.Iterables.getLast;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillHrefWithScheme;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@FindBy(xpath = ".//div[contains(@class, 'b-edit-banner2_type_cpm')]")
public class CpmBannerBlockBem extends ExtendedHtmlElement implements IWebFrom<CpmBannerInfoWeb> {

    @Name("Кнопка изменения графического объявления")
    @FindBy(xpath = ".//div[contains(@class, 'b-image-add-loader')]//button")
    private Button editImageAdButton;

    @Name("Селект выбора протокола URL")
    @FindBy(css = "span.b-href-control__protocol select")
    private SelectBEM hrefProtocolSelect;

    @Name("Ссылка на сайт")
    @FindBy(xpath = ".//span[contains(@class, 'b-href-control')]//input")
    private TextInput href;

    @Name("Инпут 'Пиксель Я.Аудиторий'")
    @FindBy(xpath = ".//div[contains(@class, 'b-edit-banner2__audience')]//span[contains(@class, 'glue-field')]//textarea")
    private TextInput pixel;

    @Name("Инпут 'Счётчик показов'")
    @FindBy(xpath = ".//div[contains(@class, 'b-edit-banner2__audit')]//div[contains(@class, 'glue-field')]//textarea")
    private TextInput viewsCounter;

    @Name("Метка 'объявление'")
    @FindBy(xpath = ".//div[@class='b-edit-banner2__label-text']")
    private WebElement bannerLabel;

    @Name("Картинка объявления")
    @FindBy(xpath = ".//div[contains(@class,'b-image-add-loader__sign-content')]")
    private WebElement imageAdPicture;


    @Override
    public void fillParameters(CpmBannerInfoWeb bean) {
        fillImageAdPictureAndSave(bean.getImageAd());
        fillHrefWithScheme(href, hrefProtocolSelect, bean.getHref(), false);
        fillTextInput(pixel, bean.getPixel());
        fillTextInput(viewsCounter, bean.getViewsCounter());
    }

    @Override
    public void checkParameters(CpmBannerInfoWeb expectedBean) {
        assertThat("баннер соответствует ожиданию", getFormFieldsAccording(expectedBean),
                beanDiffer(expectedBean));
    }

    @Override
    public CpmBannerInfoWeb getFormFieldsAccording(CpmBannerInfoWeb expectedBean) {
        return inAccordanceWith(expectedBean).forNew(CpmBannerInfoWeb.class)
                .set("bannerId", this, on(CpmBannerBlockBem.class).getBannerId())
                .set("imageAd", this, on(CpmBannerBlockBem.class).getImageAd())
                .set("href", this, on(CpmBannerBlockBem.class).getHref())
                .set("pixel", this, on(CpmBannerBlockBem.class).getPixelValue())
                .set("viewsCounter", this, on(CpmBannerBlockBem.class).getViewscounterValue())
                .getActualBean();
    }

    public Long getBannerId() {
        return getLast(StringHelper.getNumericDataFromText(bannerLabel.getAttribute("id")));
    }

    public ImageAdWeb getImageAd() {
        ImageAdWeb imageAd = new ImageAdWeb();
        imageAd.setImageAdPictureName(imageAdPicture.getText());
        return imageAd;
    }

    public String getHref() {
        return href.getText().equals("") ? "" :
                hrefProtocolSelect.getSelectedText() + href.getText();
    }

    public String getViewscounterValue() {
        return viewsCounter.getText();
    }

    public String getPixelValue() {
        return pixel.getText();
    }

    private void fillImageAdPictureAndSave(ImageAdWeb imgAd) {
        if (imgAd == null) {
            return;
        }
        editImageAdButton.click();
        ImagePopupSteps.getInstance(ImagePopupSteps.class, config).loadAdImage(imgAd);
    }
}
