package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

import ru.yandex.autotests.direct.web.data.banners.CpmTargetingType;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.allOf;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.decorators.TimeoutWaiter.timeoutHasExpired;

public class CpmTargetingTypeSelect extends ExtendedHtmlElement {
    private final static String POPUP_XPATH = "//div[contains(@class, 'popup2_visible_yes')]";

    public CpmTargetingTypeSelect(WebElement element) {
        setWrappedElement(element);
    }

    public void selectType(CpmTargetingType type) {
        if(type == null) {
            return;
        }
        openPopup();
        getSelectItem(type.getValue()).click();
    }

    private void openPopup() {
        if(!isSelectOpened()){
            click();
            assertThat(getPopupList(), should(allOf(WebElementMatchers.exists(),
                    WebElementMatchers.isDisplayed())).whileWaitingUntil(timeoutHasExpired(5000)));
        }
    }

    private boolean isSelectOpened() {
        return !findElements(By.xpath(POPUP_XPATH)).isEmpty();
    }

    private WebElement getPopupList() {
        return findElement(By.xpath(POPUP_XPATH));
    }

    private WebElement getSelectItem(String dataBemVal) {
        return getPopupList().findElement(
                By.xpath(".//div[contains(@class, 'menu__item_type_option') and contains(@data-bem, '" + dataBemVal + "')]"));
    }
}