package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import java.util.List;
import java.util.concurrent.TimeUnit;

import org.hamcrest.Matcher;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.BannerPreviewType;
import ru.yandex.autotests.direct.web.data.banners.ImageLoadType;
import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.SiteLinkInfoWeb;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static ch.lambdaj.Lambda.on;
import static com.google.common.collect.Iterables.getLast;
import static java.lang.Long.parseLong;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.containsString;
import static org.hamcrest.core.IsNot.not;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.isExists;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.timeoutHasExpired;

@FindBy(xpath = ".//div[contains(@class, 'b-edit-group ') or contains(@class, 'b-edit-group-2 ')]")
public class EditGroupWithBannerBlockBEM extends EditGroupWithBannerBlockBEMBase implements IWebFrom<BannerInfoWeb> {

    @Name("Радио 'Условия нацелевания'")
    @FindBy(css = ".b-dynamic-conditions2__type-chooser input")
    private RadioBEM targetingConditions;

    @Name("Домен")
    @FindBy(xpath = ".//div[contains(@class, 'b-dynamic-group-domain')]//input")
    private TextInput domainInput;

    @Name("Сообщение о корректности домена")
    @FindBy(xpath = ".//div[contains(@class, 'b-dynamic-group-domain__messages')]")
    private WebElement domainMessage;
    private List<BannerBlockBEM> bannerBlockBEMs;

    @Name("Блок работы с настройками на группу")
    @FindBy(xpath = ".//div[contains(@class,'b-edit-group-2__grey-wrapper')]")
    private WebElement groupSettingsBlock;

    @Name("Кнопка раскрытия настроек группы")
    @FindBy(css = "div.b-edit-group__group-properties")
    private WebElement groupSettings;

    //endregion

    //region Actions

    public List<BannerBlockBEM> getBannerBlockBEMs() {
        return bannerBlockBEMs;
    }

    @Name("Блок фразы на странице редактирования объявления")
    @FindBy(css = "tr.b-group-edit-phrase")
    public class EditBannerPhraseRow extends HtmlElement {

        @Name("Текст ключевой фразы")
        @FindBy(css = "input")
        private TextInput keyPhraseInput;

        @Name("Кнопка 'Уточнить' напротив ключевой фразы")
        @FindBy(css = "button")
        private Button refineButton;

        public String getPhraseText() {
            return keyPhraseInput.getText();
        }

        public void refinePhrase() {
            refineButton.click();
        }

        public void setPhraseText(String text) {
            fillTextInput(keyPhraseInput, text);
        }
    }

    @Override
    public void fillParameters(BannerInfoWeb bannerInfo) {
        config.getDriver().switchTo().window(config.getDriver().getWindowHandle());
        BannerBlockBEM bannerBlockBEM = getEditBannerBlock(getBannerId());
        new JavaScriptActions(config).scrollToElement(bannerBlockBEM.getWrappedElement());
        if (bannerBlockBEM != null) {
            bannerBlockBEM.fillParameters(bannerInfo);
        } else {
            throw new DirectWebError("Не найден баннер " + getBannerId());
        }

        // косыль для РМП, в котором настройки группы скрыты под выпадающий блок
        if (isExists(groupSettings) &&
                config.getDriver()
                        .findElements(By.xpath("//div[contains(@class, 'b-edit-group__expandable_open_yes')]"))
                        .isEmpty())
        {
            groupSettings.click();
        }
        fillPhrases(bannerInfo.getPhrases());
        fillMinusKeyWordsAndExpectSuccess(bannerInfo.getMinusKeywords());
        fillRegionsAndExpectSuccess(bannerInfo.getGeo());
        fillRelevanceMatch(bannerInfo.isRelevanceMatchEnabled());
        fillMaxClickPrice(bannerInfo.getMaxClickPrice());
        fillTags(bannerInfo.getTags());
        fillHierarchicalMultipliers(bannerInfo.getHierarchicalMultipliersWeb());
        fillDomain(bannerInfo.getDomain());
    }

    @Override
    public void checkParameters(BannerInfoWeb expectedBean) {
        assertThat("неверные параметры баннера ", getFormFieldsAccording(expectedBean), beanEquals(expectedBean));
        checkMinusKeywords(expectedBean.getMinusKeywords());
        checkTags(expectedBean.getTags());
        checkRelevanceMatch(expectedBean.isRelevanceMatchEnabled());
        checkMaxClickPrice(expectedBean.getMaxClickPrice());
        BannerBlockBEM bannerBlockBEM = getEditBannerBlock(getBannerId());
        new JavaScriptActions(config).scrollToElement(bannerBlockBEM.getWrappedElement());
        if (bannerBlockBEM != null) {
            bannerBlockBEM.checkBannerType(expectedBean.getBannerType());
            bannerBlockBEM.checkDisplayHref(expectedBean.getDisplayHref());
            bannerBlockBEM.checkSiteLinks(expectedBean.getSitelinks());
            bannerBlockBEM.checkContactInfo(expectedBean.getContactInfo());
            bannerBlockBEM.checkCallouts(expectedBean.getCallouts());
            bannerBlockBEM.checkIsBannerMobile(expectedBean.getIsMobileBannerType());
            bannerBlockBEM.checkImageAdPicture(expectedBean.getImageAd());
        } else {
            throw new DirectWebError("Не найден баннер " + getBannerId());
        }
    }

    @Override
    public BannerInfoWeb getFormFieldsAccording(BannerInfoWeb expectedBean) {
        BannerBlockBEM bannerBlockBEM = getEditBannerBlock(getBannerId());
        BannerInfoWeb actualBannerInfo;
        if (bannerBlockBEM != null) {
            actualBannerInfo = bannerBlockBEM.getFormFieldsAccording(expectedBean);
        } else {
            throw new DirectWebError("Не найден баннер " + getBannerId());
        }
        BannerInfoWeb bannerInfo = inAccordanceWith(expectedBean).forExisting(actualBannerInfo)
                .set("geo", this, on(EditGroupWithBannerBlockBEM.class).getRegionIDs())
                .getActualBean();
        bannerInfo.setAdGroupID(expectedBean.getAdGroupID());
        return bannerInfo;
    }

    public void checkImageOnPopup(Matcher matcher) {
        BannerBlockBEM bannerBlockBEM = getEditBannerBlock(getBannerId());
        if (bannerBlockBEM != null) {
            bannerBlockBEM.checkImageOnPopup(matcher);
        } else {
            throw new DirectWebError("Не найден баннер " + getBannerId());
        }
    }

    public void fillImageAndSave(ImageLoadType type, String img) {
        BannerBlockBEM bannerBlockBEM = getEditBannerBlock(getBannerId());
        if (bannerBlockBEM != null) {
            bannerBlockBEM.fillImageAndSave(type, img);
        } else {
            throw new DirectWebError("Не найден баннер " + getBannerId());
        }
    }

    public void removeImg() {
        BannerBlockBEM bannerBlockBEM = getEditBannerBlock(getBannerId());
        if (bannerBlockBEM != null) {
            bannerBlockBEM.removeImg();
        } else {
            throw new DirectWebError("Не найден баннер " + getBannerId());
        }
    }

    public void checkMobileCheckboxShouldBe(Matcher<TypifiedElement> matcher) {
        BannerBlockBEM bannerBlockBEM = getEditBannerBlock(getBannerId());
        if (bannerBlockBEM != null) {
            bannerBlockBEM.checkMobileCheckboxShouldBe(matcher);
        } else {
            throw new DirectWebError("Не найден баннер " + getBannerId());
        }
    }


    //endregion

    //region Field getters

    public BannerBlockBEM getEditBannerBlock(Long bannerId) {
        BannerBlockBEM block;
        if (bannerId == null || bannerId.equals(0L)) {
            block = getLast(bannerBlockBEMs);
        } else {
            block = bannerBlockBEMs.stream()
                    .filter(t -> t.getBannerId().equals(bannerId))
                    .findFirst().orElse(null);
        }

        if (block != null) {
            block.setConfig(config);
        }
        return block;
    }

    public void fillSitelinks(String link, SiteLinkInfoWeb[] sitelinks) {
        config.getDriver().switchTo().window(config.getDriver().getWindowHandle());
        BannerBlockBEM bannerBlockBEM = getEditBannerBlock(getBannerId());
        bannerBlockBEM.fillLinks(link, sitelinks);
    }

    public BannerSiteLinksPopupBlockBEM getEditSiteLinksBlock() {
        BannerBlockBEM bannerBlockBEM = getEditBannerBlock(getBannerId());
        return bannerBlockBEM.getLinksPopupBlock();
    }


    public Long getAdGroupID() {
        return parseLong(getAdGroupId(this.getAttribute("data-bem")));
    }

    public RadioBEM getTargetingConditions() {
        return targetingConditions;
    }

    public void fillDomain(String domain) {
        if (domain == null) {
            return;
        }
        domainInput.clear();
        domainInput.sendKeys(domain);
        should(not(WebElementMatchers.hasClass(containsString("hidden"))))
                .whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(4))).matches(domainMessage);
        should(WebElementMatchers.hasClass(containsString("hidden")))
                .whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(4))).matches(domainMessage);
    }

    public String getDomainText() {
        return domainInput.getText();
    }

    public void chooseBannerPreviewType(Long bannerId, BannerPreviewType type) {
        getEditBannerBlock(bannerId).clickBannerPreviewType(type);
    }

    public WebElement getBannerPreview(Long bannerId) {
        return getEditBannerBlock(bannerId).getBannerPreview();
    }

    public WebElement getGroupSettingsBlock() {
        return groupSettingsBlock;
    }

    @Override
    public void openMinusWordsPopup() {
        super.openMinusWordsPopup();
    }

    @Override
    public void openRegionsPopup() {
        super.openRegionsPopup();
    }

    public void openRetargetingPopup() {
        super.clickAddRetargetingCondition();
    }

    @Override
    public void openAdjustmentRatesPopup() {
        super.openAdjustmentRatesPopup();
    }

    //endregion
}
