package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Stream;

import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.web.objects.adjustment.rates.HierarchicalMultipliersWeb;
import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;
import ru.yandex.autotests.direct.web.objects.retargeting.RetargetingConditionWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.pages.adjustment.blocks.AdjustmentRatesPopupBlock;
import ru.yandex.autotests.direct.web.pages.regionselectpopup.RegionSelectPopupBlockBEM;
import ru.yandex.autotests.direct.web.pages.retargeting.blocks.bem.EditConditionPopupBlockBem;
import ru.yandex.autotests.direct.web.pages.retargeting.blocks.bem.RetargetingPopupBlockBEM;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.autotests.direct.web.webelements.NumericInput;
import ru.yandex.autotests.direct.web.webelements.bem.TumblerBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static java.util.Arrays.stream;
import static java.util.stream.Collectors.toList;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.anyOf;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasItems;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.OperationSystemUtils.sleep;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.getVisibleElement;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.should;
import static ru.yandex.qatools.htmlelements.matchers.MatcherDecorators.timeoutHasExpired;
import static ru.yandex.qatools.htmlelements.matchers.WebElementMatchers.exists;

public class EditGroupWithBannerBlockBEMBase extends ExtendedHtmlElement {

    public final static String PROTOCOL_REGEXP = "(https?://)(.*)";
    public final static String NEW_AD_GROUP_ID = "new";
    public final static String FIRST_NEW_AD_GROUP_ID = "new1";
    private static final String MINUS_KEYWORDS_REGEXP = "\\s-.*$";

    private Long bannerId;
    private MinusWordsPopupBEM minusWordsPopup;
    private RetargetingPopupBlockBEM retargetingPopupBlock;
    private EditConditionPopupBlockBem editRetargetingConditionPopup;
    protected TagsPopupBlockBEM tagsPopup;
    private List<RegionSelectPopupBlockBEM> regionSelectPopups;
    private List<RetargetingConditionRowBEM> retargetingConditionRows;
    private List<EditBannerPhraseRow> phraseRows;

    @Name("Задать метки")
    @FindBy(xpath = ".//button[contains(@class, 'b-group-tags')]")
    private Button setTagsButton;

    @Name("Список тегов")
    @FindBy(xpath = ".//span[@class='b-group-tags-list__link']")
    private List<WebElement> tagsList;

    @Name("Выбор регионов показа")
    @FindBy(xpath = ".//div[contains(@class, 'b-regions-selector')]//button")
    private WebElement selectRegionButton;

    @Name("Задать минус-слова")
    @FindBy(xpath = ".//div[contains(@class, 'b-minus-words-control__switcher ')]/button")
    private Button setMinusKeywordsButton;

    @Name("Поле с минус-словами")
    @FindBy(xpath = ".//div[contains(@class, 'b-minus-words-control__minus-words-preview')]")
    private WebElement minusKeywords;

    @Name("Регионы показа")
    @FindBy(xpath = ".//div[contains(@class,'b-regions-selector__selected-regions')]")
    private WebElement regionsText;

    @Name("географические идентификаторы регионов")
    @FindBy(xpath = ".//input[contains(@class, 'b-regions-selector__geo')]")
    private WebElement regionIDs;

    @Name("Добавление условий ретаргетинга")
    @FindBy(xpath = ".//button[contains(@class, 'b-group-retargeting2__switcher')]")
    private List<Button> addRetargetingCondition;

    @Name("Очистить новые ключевые фразы")
    @FindBy(xpath = ".//span[contains(@class,'b-phrases-input__button_name_clear')]")
    private WebElement clearNewKeyPhrasesLink;

    @Name("Упорядочить и уточнить новые ключевые фразы")
    @FindBy(xpath = ".//span[contains(@class, 'b-phrases-input__button_name_split')]")
    private WebElement refineNewKeyPhrasesLink;

    @Name("Поле для ввода ссылки на приложение")
    @FindBy(xpath = ".//textarea[contains(@class, 'b-phrases-input__phrases-textarea')]")
    private WebElement newKeyPhrases;

    @Name("Кнопка 'Изменить' корректировки ставок")
    @FindBy(css = "div.b-adjustment-rates-popup button")
    private Button changeAdjustmentRates;

    @Name("Поле 'Максимальная цена клика для новых и измененных условий показа'")
    @FindBy(xpath = ".//div[contains(@class, 'b-edit-phrase-price_control-type_general-limit')]//input")
    private List<NumericInput> maxClickPriceInput;

    @Name("Тумблер 'Использовать автотаргетинг'")
    @FindBy(xpath = ".//span[contains(@class, 'b-edit-group-2__relevance-match-tumbler') or contains(@class, 'b-edit-group__relevance-match-tumbler')]")
    private List<WebElement> relevanceMatchTumbler;

    @Name("Попап корректировки ставок")
    private AdjustmentRatesPopupBlock adjustmentRatesPopupBlock;

    @Name("Инпут максимальной ставки")
    @FindBy(css = "input.b-edit-phrase-price__control")
    private TextInput maxPriceInput;

    //endregion

    public void forBannerId(Long bannerId) {
        this.bannerId = bannerId;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public void fillRegionsAndExpectSuccess(String geo) {
        fillRegions(geo);
        assertThat(regionSelectPopups, should(hasSize(0)) //after closing region popup should be deleted from DOM
                .whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(5))));
    }

    public void fillRegions(String geo) {
        if (geo == null) {
            return;
        }
        selectRegionButton.click();
        RegionSelectPopupBlockBEM block = getVisibleElement(regionSelectPopups);
        if (block == null) {
            throw new DirectWebError("Не найден блок редактирования региона");
        }
        block.clearAllRegions();
        block.fillRegions(geo);
    }

    public void fillMinusKeyWordsAndExpectSuccess(String[] minusKeyWords) {
        fillMinusKeyWords(minusKeyWords);
        Assert.assertThat("попап минус слов не соответствует ожиданиям", minusWordsPopup,
                should(anyOf(not(WebElementMatchers.exists()), not(WebElementMatchers.isDisplayed())))
                        .whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(
                                DirectTestRunProperties.getInstance()
                                        .getDirectWebWebdriverImplicityWaitTimeoutSec()))));
    }

    public void fillMinusKeyWords(String[] minusKeyWords) {
        if (minusKeyWords == null) {
            return;
        }
        setMinusKeywordsButton.click();
        minusWordsPopup.setConfig(config);
        minusWordsPopup.fillMinusKeywordsTextInput(minusKeyWords);
        minusWordsPopup.clickOnSaveButton();
    }

    public void fillMaxPrice(Float maxPrice) {
        fillTextInput(maxPriceInput, maxPrice.toString());
    }

    public void checkMinusKeyWordsPopup(Matcher matcher) {
        assertThat(minusWordsPopup, should(matcher).whileWaitingUntil(
                timeoutHasExpired(TimeUnit.SECONDS.toMillis(
                        DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec()))));
    }

    public List<String> getMinusKeywords() {
        setMinusKeywordsButton.click();
        waitForElement(minusWordsPopup, 3, WebElementMatchers.isDisplayed());
        List<String> result = minusWordsPopup.getMinusWords();
        minusWordsPopup.clickOnCancelButton();
        return result;
    }

    public String[] getPhrases() {
        return phraseRows.stream().map(EditBannerPhraseRow::getPhraseText).toArray(String[]::new);
    }

    public List<String> getTags() {
        return tagsList.stream().map(x -> x.getText()).collect(toList());
    }

    public HierarchicalMultipliersWeb getHierarchicalMultipliersAccording(HierarchicalMultipliersWeb expectedBean) {
        changeAdjustmentRates.click();
        HierarchicalMultipliersWeb result = adjustmentRatesPopupBlock.getFormFieldsAccording(expectedBean);
        adjustmentRatesPopupBlock.clickCancel();
        return result;
    }

    protected void checkMinusKeywords(String[] keywords) {
        if (keywords == null) {
            return;
        }
        List<String> actualMinusKeywords = getMinusKeywords();
        assertThat("неверно установлены минус-слова", actualMinusKeywords,
                containsInAnyOrder(stream(keywords).map(x -> x.trim().replaceFirst("^-", "")).toArray()));
    }

    public void checkPhraseList(Matcher matcher) {
        new JavaScriptActions(config).scrollToElement(phraseRows.get(0).getWrappedElement());
        Assert.assertThat("список фраз не соответствует ожиданиям.",
                extract(phraseRows, on(EditBannerPhraseRow.class).getPhraseText()), matcher);
    }

    public void editPhraseText(String oldPhraseText, String newPhraseText) {
        phraseRows.stream().filter(phraseRow -> phraseRow.getPhraseText().replaceAll(MINUS_KEYWORDS_REGEXP, "")
                .replaceAll("\\+", "").equals(oldPhraseText)).forEach(phraseRow -> {
            phraseRow.setPhraseText(newPhraseText);
        });
    }

    public void clickRefineButtonForPhrase(String phraseText) {
        phraseRows.stream()
                .filter(phraseRow -> phraseRow.getPhraseText().contains(phraseText))
                .forEach(EditBannerPhraseRow::refinePhrase);
    }

    protected void fillPhrases(BannerPhraseInfoWeb[] phrases) {
        if (phrases == null) {
            return;
        }
        List<String> phrasesList = Stream.of(phrases).map(x -> x.getPhrase()).collect(toList());
        newKeyPhrases.clear();
        newKeyPhrases.sendKeys(StringUtils.join(phrasesList, ",") + Keys.TAB);
    }

    protected void checkTags(List<String> tags) {
        if (tags == null) {
            return;
        }
        List<String> actualTags = tagsList.stream().map(WebElement::getText).collect(toList());
        assertThat("установлены неверные тэги", actualTags, hasItems(tags.toArray(new String[tags.size()])));
    }

    protected void fillTags(List<String> tags) {
        if (tags == null) {
            return;
        }
        setTagsButton.click();
        tagsPopup.deselectAllTags();
        tagsPopup.fillTagsTextInput(tags);
        tagsPopup.clickOnSaveButton();
        assertThat("не сохранились метки", tagsPopup, should(not(WebElementMatchers.isDisplayed()))
                .whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(
                        DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec()))));
    }

    public void fillHierarchicalMultipliers(HierarchicalMultipliersWeb hierarchicalMultipliers) {
        if (hierarchicalMultipliers == null) {
            return;
        }
        changeAdjustmentRates.click();
        adjustmentRatesPopupBlock.fillParameters(hierarchicalMultipliers);
    }

    private RetargetingPopupBlockBEM onRetargetingPopup() {
        return retargetingPopupBlock;
    }

    private EditConditionPopupBlockBem onEditRetargetingConditionPopup() {
        return editRetargetingConditionPopup;
    }

    private List<RetargetingConditionRowBEM> getRetargetingConditionRows() {
        return retargetingConditionRows;
    }

    private RetargetingConditionRowBEM getRetargetingConditionRow(String conditionName) {
        for (RetargetingConditionRowBEM row : getRetargetingConditionRows()) {
            if (row.getConditionNameText().equals(conditionName)) {
                return row;
            }
        }
        return null;
    }

    public void clickAddRetargetingCondition() {
        getVisibleElement(addRetargetingCondition).click();
    }

    public void checkRetargetingConditionParameters(RetargetingConditionWeb conditionWeb) {
        RetargetingConditionRowBEM conditionRow =
                getRetargetingConditionRow(conditionWeb.getRetargetingConditionName());
        if (conditionRow == null) {
            throw new DirectWebError("Не найдено условие " + conditionWeb.getRetargetingConditionName());
        } else {
            conditionRow.clickOnName();
            onEditRetargetingConditionPopup().checkParameters(conditionWeb);
            onEditRetargetingConditionPopup().clickCancel();
        }
    }

    public void checkHierarchicalMultipliersParameters(HierarchicalMultipliersWeb hierarchicalMultipliers) {
        if (hierarchicalMultipliers == null) {
            return;
        }
        changeAdjustmentRates.click();
        adjustmentRatesPopupBlock.checkParameters(hierarchicalMultipliers);
        adjustmentRatesPopupBlock.clickCancel();
    }


    public void addNewRetargetingCondition(RetargetingConditionWeb conditionWeb) {
        onRetargetingPopup().clickAddRulesButton();
        onEditRetargetingConditionPopup().fillParameters(conditionWeb);
        onEditRetargetingConditionPopup().clickSave();
        checkEditRetargetingConditionPopup(not(exists()));
        onRetargetingPopup().clickSave();
        checkRetargetingPopup(not(exists()));
    }

    public void addSavedRetargetingCondition(String conditionName) {
        onRetargetingPopup().checkSavedRetargetingCondition(conditionName);
        sleep(500);
        onRetargetingPopup().clickSave();
        checkRetargetingPopup(not(exists()));
    }

    public void editSavedRetargetingCondition(String conditionName, RetargetingConditionWeb conditionWeb) {
        onRetargetingPopup().clickEditSavedRetargetingCondition(conditionName);
        onEditRetargetingConditionPopup().fillParameters(conditionWeb);
        onEditRetargetingConditionPopup().clickSave();
        checkEditRetargetingConditionPopup(not(exists()));
        onRetargetingPopup().clickCancel();
    }

    public void deleteCondition(String conditionName) {
        RetargetingConditionRowBEM conditionRow = getRetargetingConditionRow(conditionName);
        if (conditionRow == null) {
            throw new DirectWebError("Не найдено условие " + conditionName);
        } else {
            conditionRow.clickDelete();
        }
    }

    public void clickEditCondition(String conditionName) {
        RetargetingConditionRowBEM conditionRow = getRetargetingConditionRow(conditionName);
        if (conditionRow == null) {
            throw new DirectWebError("Не найдено условие " + conditionName);
        } else {
            conditionRow.clickOnName();
        }
    }

    public void checkRetargetingPopup(Matcher matcher) {
        assertThat("окно ретаргетинга не прошло проверку", onRetargetingPopup(),
                should(matcher).whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(
                        DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec()
                ))));
    }

    public void checkEditRetargetingConditionPopup(Matcher matcher) {
        assertThat("окно редактирования условий ретаргетинга не прошло проверку", onEditRetargetingConditionPopup(),
                should(matcher).whileWaitingUntil(timeoutHasExpired(TimeUnit.SECONDS.toMillis(
                        DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec()
                ))));
    }


    public void checkCantEditFields(RetargetingConditionWeb conditionWeb) {
        RetargetingConditionRowBEM conditionRow =
                getRetargetingConditionRow(conditionWeb.getRetargetingConditionName());
        if (conditionRow == null) {
            throw new DirectWebError("Не найдено условие " + conditionWeb.getRetargetingConditionName());
        } else {
            conditionRow.clickOnName();
            onEditRetargetingConditionPopup().checkRetargetingPopupFields(conditionWeb,
                    ru.yandex.qatools.htmlelements.matchers.
                            WrapsElementMatchers.hasAttribute("disabled", not(equalTo((String) null)))
            );
            onEditRetargetingConditionPopup().clickCancel();
        }
    }

    protected String getAdGroupId(String data) {
        Pattern pattern = Pattern.compile("\"modelId\":[-0-9a-zA-Z\"]*");
        java.util.regex.Matcher matcher = pattern.matcher(data);
        String result = null;
        if (matcher.find()) {
            result = matcher.group().replaceAll("[\":]", "").replace("modelId", "");
        }
        //для совместимости с бинами (в них хранится 0 в поле bannerId для нового баннера)
        if (NEW_AD_GROUP_ID.equals(result) || FIRST_NEW_AD_GROUP_ID.equals(result)) {
            result = "0";
        }
        return result;
    }

    public String getRegionIDs() {
        return regionIDs.getAttribute("value").replace(" ", "");
    }

    public void openMinusWordsPopup() {
        setMinusKeywordsButton.click();
    }

    public void openRegionsPopup() {
        selectRegionButton.click();
    }

    public void openAdjustmentRatesPopup() {
        changeAdjustmentRates.click();
    }

    public void fillMaxClickPrice(Double maxClickPrice) {
        if (maxClickPrice != null) {
            fillTextInput(getMaxClickPriceInput(), maxClickPrice.toString());
        }
    }

    public void checkMaxClickPrice(Double maxClickPrice) {
        if (maxClickPrice != null) {
            assertThat("максимальная цена клика соответствует ожидаемой", getMaxClickPriceInput().getText(),
                    equalTo(maxClickPrice.toString()));
        }
    }

    public void fillRelevanceMatch(Boolean isEnabled) {
        if (isEnabled != null) {
            getRelevanceMatchTumbler().set(isEnabled);
        }
    }

    public void checkRelevanceMatch(Boolean isEnabled) {
        if (isEnabled != null) {
            assertThat("автотаргетинг соответствует ожиданию", getRelevanceMatchTumbler().isSelected(),
                    equalTo(isEnabled));
        }
    }

    public String getMaxClickPriceValue() {
        return getMaxClickPriceInput().getText();
    }

    public TextInput getMaxClickPriceInput() {
        return getVisibleElement(maxClickPriceInput);
    }

    //TODO: should change method when autoTargeting will be open for all users
    public TumblerBEM getRelevanceMatchTumbler() {
        return new TumblerBEM(getVisibleElement(relevanceMatchTumbler).findElement(By.xpath(".//input")));
    }

    @Name("Блок фразы на странице редактирования объявления")
    @FindBy(css = "tr.b-group-edit-phrase")
    public class EditBannerPhraseRow extends HtmlElement {

        @Name("Текст ключевой фразы")
        @FindBy(css = "input")
        private TextInput keyPhraseInput;

        @Name("Кнопка 'Уточнить' напротив ключевой фразы")
        @FindBy(css = "button")
        private Button refineButton;

        public String getPhraseText() {
            return keyPhraseInput.getText();
        }

        public void setPhraseText(String text) {
            fillTextInput(keyPhraseInput, text);
        }

        public void refinePhrase() {
            refineButton.click();
        }
    }
}
