package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.BannerPreviewType;
import ru.yandex.autotests.direct.web.data.RadioInputMethod;
import ru.yandex.autotests.direct.web.data.SelectInputMethod;
import ru.yandex.autotests.direct.web.data.banners.ImageLoadType;
import ru.yandex.autotests.direct.web.objects.banners.GroupMobileInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.MobileAppBannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.InterestInfoWeb;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.autotests.direct.web.util.testinterfaces.IWebFrom;
import ru.yandex.autotests.direct.web.webelements.bem.MobileAppOSSelectBEM;
import ru.yandex.autotests.direct.web.webelements.bem.RadioBEM;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static ch.lambdaj.Lambda.on;
import static com.google.common.collect.Iterables.getLast;
import static java.lang.Long.parseLong;
import static java.util.Objects.isNull;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillRadio;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillSelect;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.beanutils.BeanFieldsSetter.inAccordanceWith;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

@FindBy(xpath = ".//div[contains(@class, 'b-edit-group ')]")
public class EditMobileGroupWithBannerBlockBEM extends EditGroupWithBannerBlockBEMBase implements IWebFrom<MobileAppBannerInfoWeb> {

    //region Fields

    @Name("Ссылка на мобильное приложение")
    @FindBy(xpath = ".//span[contains(@class, 'b-edit-group-mobile-content-href__url')]//input")
    private TextInput href;

    @Name("Спиннер загрузки деталей мобильного приложения")
    @FindBy(css = ".b-edit-group-mobile-content-href__spin")
    private WebElement mobileContentSpinner;

    @Name("Операционная система и версия")
    @FindBy(xpath = ".//span[@class = 'b-mobile-content-os__select']//select")
    private MobileAppOSSelectBEM OSSelect;

    @Name("Выбор типа устройств")
    @FindBy(xpath = ".//input[@name = 'device_type_targeting']")
    private RadioBEM deviceTypeTargetingRadio;

    @Name("Выбор типа связи")
    @FindBy(xpath = ".//input[@name = 'network_targeting']")
    private RadioBEM networkTargetingRadio;

    @Name("Блок работы с настройками на группу")
    @FindBy(xpath = ".//div[contains(@class,'b-edit-group__grey-wrapper')]")
    private WebElement groupSettingsBlock;

    @Name("Кнопка 'Интересы'")
    @FindBy(xpath = ".//div[contains(@class, 'b-group-interests__edit-param-button')]//button")
    private Button addInterestButton;

    @Name("Раскрыть настройки на группу")
    @FindBy(xpath = ".//div[contains(@class, 'b-edit-group__group-properties')]")
    private WebElement groupProperties;

    private InterestPopup interestPopup;

    private List<MobileAppBannerBlockBEM> mobileAppBannerBlockBEMs;

    //endregion

    //region Actions

    private void inputHref(String text) {
        if (text == null) {
            return;
        }
        href.getWrappedElement().click();
        fillTextInput(href, text);
        //Кликаем по названию группы что бы сбросить фокус
        config.getDriver().findElement(By.cssSelector(".b-edit-group-header__control-content")).click();
    }

    public List<MobileAppBannerBlockBEM> getMobileAppBannerBlockBEMs() {
        return mobileAppBannerBlockBEMs;
    }

    public void fillGroupMobileInfo(GroupMobileInfoWeb groupMobileInfo) {
        if (groupMobileInfo == null) {
            return;
        }
        fillRadio(networkTargetingRadio, StringUtils.join(groupMobileInfo.getNetworkTargeting(), ","),
                RadioInputMethod.BY_VALUE);
        fillRadio(deviceTypeTargetingRadio, StringUtils.join(groupMobileInfo.getDeviceTypeTargeting(), ","),
                RadioInputMethod.BY_VALUE);
        fillSelect(OSSelect, groupMobileInfo.getOSModel(), SelectInputMethod.BY_TEXT);
    }

    public void fillImageAndSave(ImageLoadType type, String img) {
        MobileAppBannerBlockBEM bannerBlockBEM = getEditBannerBlock(getBannerId());
        if (bannerBlockBEM != null) {
            bannerBlockBEM.fillImageAndSave(type, img);
        } else {
            throw new DirectWebError("Не найден баннер " + getBannerId());
        }
    }

    public void fillInterests(List<InterestInfoWeb> interests) {
        if (interests == null) {
            return;
        }
        addInterestButton.click();
        interestPopup.fillParameters(interests);
        interestPopup.clickSave();
        waitForElement(interestPopup.getWrappedElement(), 5, not(WebElementMatchers.isDisplayed()));
    }

    public void checkImageOnPopup(Matcher matcher) {
        MobileAppBannerBlockBEM bannerBlockBEM = getEditBannerBlock(getBannerId());
        if (bannerBlockBEM != null) {
            bannerBlockBEM.checkImageOnPopup(matcher);
        } else {
            throw new DirectWebError("Не найден баннер " + getBannerId());
        }
    }

    @Override
    public void fillParameters(MobileAppBannerInfoWeb bannerInfo) {
        config.getDriver().switchTo().window(config.getDriver().getWindowHandle());
        MobileAppBannerBlockBEM bannerBlockBEM = getEditBannerBlock(getBannerId());
        clickOnGroupPropertiesIfNotOpened();
        fillGroupMobileInfo(bannerInfo.getGroupMobileInfo());
        new JavaScriptActions(config).scrollToElement(bannerBlockBEM.getWrappedElement());
        if (bannerBlockBEM != null) {
            bannerBlockBEM.fillParameters(bannerInfo);
        } else {
            throw new DirectWebError("Не найден баннер " + getBannerId());
        }
        if (!isNull(bannerInfo.getPhrases())) {
            fillPhrases(bannerInfo.getPhrases());
        }
        fillMinusKeyWordsAndExpectSuccess(bannerInfo.getMinusKeywords());
        fillRelevanceMatch(bannerInfo.isRelevanceMatchEnabled());
        fillInterests(bannerInfo.getInterests());
        fillMaxClickPrice(bannerInfo.getMaxClickPrice());
        fillRegionsAndExpectSuccess(bannerInfo.getGeo());
        fillTags(bannerInfo.getTags());
        fillHierarchicalMultipliers(bannerInfo.getHierarchicalMultipliersWeb());
    }

    public List<String> getDeviceTypeTargeting() {
        return Arrays.asList(deviceTypeTargetingRadio.getSelectedButton().getAttribute("value").split(","));
    }

    public List<String> getNetworkTargeting() {
        return Arrays.asList(networkTargetingRadio.getSelectedButton().getAttribute("value").split(","));
    }

    public String getOSModel() {
        return OSSelect.getSelectedText();
    }

    private GroupMobileInfoWeb getGroupMobileFieldsAccording(GroupMobileInfoWeb expectedBean) {
        return inAccordanceWith(expectedBean).forNew(GroupMobileInfoWeb.class)
                .set("deviceTypeTargeting", this, on(EditMobileGroupWithBannerBlockBEM.class).getDeviceTypeTargeting())
                .set("networkTargeting", this, on(EditMobileGroupWithBannerBlockBEM.class).getNetworkTargeting())
                .set("OSModel", this, on(EditMobileGroupWithBannerBlockBEM.class).getOSModel())
                .getActualBean();
    }

    private void checkMobileGroupParameters(GroupMobileInfoWeb expectedBean) {
        if (expectedBean == null) {
            return;
        }
        assertThat("неверные параметры мобильной группы", getGroupMobileFieldsAccording(expectedBean),
                beanDiffer(expectedBean));
    }

    @Override
    public void checkParameters(MobileAppBannerInfoWeb expectedBean) {
        assertThat("неверные параметры баннера ", getFormFieldsAccording(expectedBean), beanEquals(expectedBean).ignoreFields("maxClickPrice"));
        if (expectedBean.getGroupMobileInfo() != null) {
            expectedBean.getGroupMobileInfo().setStoreContentHref(null);
        }
        checkMobileGroupParameters(expectedBean.getGroupMobileInfo());
        checkMinusKeywords(expectedBean.getMinusKeywords());
        checkTags(expectedBean.getTags());
        checkRelevanceMatch(expectedBean.isRelevanceMatchEnabled());
        checkMaxClickPrice(expectedBean.getMaxClickPrice());
        checkHierarchicalMultipliersParameters(expectedBean.getHierarchicalMultipliersWeb());
        if (expectedBean.getInterests() != null) {
            addInterestButton.click();
            interestPopup.checkParameters(expectedBean.getInterests());
            interestPopup.clickCancel();
        }
    }

    public void checkMobileAppBannerPreviewParameters(MobileAppBannerInfoWeb expectedBean) {
        MobileAppBannerBlockBEM bannerBlockBEM = getEditBannerBlock(getBannerId());
        if (bannerBlockBEM == null) {
            throw new DirectWebError("Не найден баннер " + getBannerId());
        }
        bannerBlockBEM.checkMobileAppBannerPreviewParameters(expectedBean);
    }

    @Override
    public MobileAppBannerInfoWeb getFormFieldsAccording(MobileAppBannerInfoWeb expectedBean) {
        MobileAppBannerBlockBEM bannerBlockBEM = getEditBannerBlock(getBannerId());
        MobileAppBannerInfoWeb actualBannerInfo;
        if (bannerBlockBEM != null) {
            actualBannerInfo = bannerBlockBEM.getFormFieldsAccording(expectedBean);
        } else {
            throw new DirectWebError("Не найден баннер " + getBannerId());
        }
        MobileAppBannerInfoWeb bannerInfo = inAccordanceWith(expectedBean).forExisting(actualBannerInfo)
                .set("geo", this, on(EditGroupWithBannerBlockBEM.class).getRegionIDs())
                .getActualBean();
        bannerInfo.setAdGroupID(expectedBean.getAdGroupID());
        return bannerInfo;
    }

    //endregion

    //region Field getters

    public MobileAppBannerBlockBEM getEditBannerBlock(Long bannerId) {
        MobileAppBannerBlockBEM block;
        if (bannerId == null || bannerId.equals(0L)) {
            block = getLast(mobileAppBannerBlockBEMs);
        } else {
            block = mobileAppBannerBlockBEMs.stream()
                    .filter(t -> t.getBannerId().equals(bannerId))
                    .findFirst().orElse(null);
        }

        if (block != null) {
            block.setConfig(config);
        }
        return block;
    }

    public Long getAdGroupID() {
        return parseLong(getAdGroupId(this.getAttribute("data-bem")));
    }

    public void chooseBannerPreviewType(Long bannerId, BannerPreviewType type) {
        getEditBannerBlock(bannerId).clickBannerPreviewType(type);
    }

    public WebElement getBannerPreview(Long bannerId) {
        return getEditBannerBlock(bannerId).getBannerPreview();
    }

    public WebElement getGroupSettingsBlock() {
        return groupSettingsBlock;
    }

    @Override
    public void openMinusWordsPopup() {
        super.openMinusWordsPopup();
    }

    @Override
    public void openRegionsPopup() {
        super.openRegionsPopup();
    }

    public void openRetargetingPopup() {
        super.clickAddRetargetingCondition();
    }

    @Override
    public void openAdjustmentRatesPopup() {
        super.openAdjustmentRatesPopup();
    }
    //endregion

    public void clickOnGroupPropertiesIfNotOpened() {
        if (findElements(By.xpath(".//div[contains(@class, 'b-edit-group__expandable_open_yes')]")).size() == 0) {
            groupProperties.click();
        }
    }
}
