package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import java.util.List;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.data.banners.GroupChangesBlockTabs;
import ru.yandex.autotests.direct.web.data.banners.GroupChangesInfo;
import ru.yandex.autotests.direct.web.data.textresources.EditBannerResource;
import ru.yandex.autotests.direct.web.objects.banners.commons.SiteLinkInfoWeb;
import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.steps.AlertSteps;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.WebElementsActions;
import ru.yandex.autotests.direct.web.webelements.bem.CheckBoxBEM;
import ru.yandex.autotests.direct.web.webelements.bem.SelectBEM;
import ru.yandex.qatools.allure.webdriver.steps.BaseSteps;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;

import static java.lang.String.format;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillHrefWithScheme;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.fillTextInput;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.setCheckboxState;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@FindBy(xpath = "//div[contains(@class, 'b-edit-groups-mass-actions__popup-content')]")
public class GroupChangesBlockBEM extends ExtendedHtmlElement {

    private AlertSteps onAlert() {
        return BaseSteps.getInstance(AlertSteps.class, config);
    }

    @Name("Вкладки групповых действий")
    @FindBy(xpath = ".//div[contains(@class, 'b-chooser__item_name_')]/div")
    public List<WebElement> tabs;

    @Name("Новая ссылка на вкладке 'Ссылка на сайт'")
    @FindBy(xpath = ".//input[contains(@name, 'new-href')]")
    public TextInput newSiteLink;

    @Name("Протокол новой ссылки на вкладке 'Ссылка на сайт'")
    @FindBy(xpath = ".//select[@name='url_protocol']")
    public SelectBEM newSitelinkschemeSelect;

    @Name("'Изменить ссылку на вкладке 'Ссылка на сайт'")
    @FindBy(xpath = ".//button[contains(@name, 'change-href')]")
    public Button replaceHrefButton;

    @Name("Поле 'Найти' на вкладке 'Часть ссылки'")
    @FindBy(xpath = ".//input[@id= 'href-from']")
    public TextInput linkPartFindBy;

    @Name("Поле 'Заменить на' на вкладке 'Часть ссылки'")
    @FindBy(xpath = ".//input[@id= 'href-to']")
    public TextInput linkPartReplaceWith;

    @Name("'Исправлять быстрые ссылки на вкладке 'Часть ссылки''")
    @FindBy(xpath = ".//input[@id= 'update-sitelinks']")
    public CheckBoxBEM fixQuickLinks;

    @Name("'Изменить часть ссылки' на вкладке 'Часть ссылки'")
    @FindBy(xpath = ".//button[contains(@class, 'update-href')]")
    public Button updateHrefButton;

    @Name("Поле 'Новый домен' на вкладке 'Домен'")
    @FindBy(xpath = ".//input[@id= 'new-domain']")
    public TextInput newDomain;

    @Name("Изменить домен на вкладке 'Домен'")
    @FindBy(xpath = ".//button[contains(@class, 'replace-domain')]")
    public Button updateDomainButton;

    @Name("Поле 'Найти' на вкладке 'Часть текста'")
    @FindBy(xpath = ".//input[@id= 'text-from']")
    public TextInput bodyPartFindBy;

    @Name("Поле 'Заменить на' на вкладке 'Часть текста'")
    @FindBy(xpath = ".//input[@id= 'text-to']")
    public TextInput bodyPartReplaceWith;

    @Name("Изменить часть текста на вкладке 'Часть тектса'")
    @FindBy(xpath = ".//button[contains(@class, 'update-text')]")
    public Button updateTextButton;

    @Name("Поле 'Добавить' на вкладке 'Минус слова'")
    @FindBy(xpath = ".//textarea[@id='add-minus-words']")
    public TextInput minusKeywords;


    @Name("'Изменить минус слова' на вкладке 'Минус слова'")
    @FindBy(xpath = ".//button[contains(@class, 'update-minus-words')]")
    public Button addMinusWordsButton;

    public BannerSiteLinksPopupBlockBEM linksPopupBlock;

    @Name("Изменить бысрые ссылки на вкладке 'Быстрые ссылки'")
    @FindBy(xpath = ".//button[contains(@class, 'add-sitelinks')]")
    public Button addSiteLinksButton;

    public BannerSiteLinksPopupBlockBEM getLinksPopupBlock() {
        linksPopupBlock.setConfig(config);
        return linksPopupBlock;
    }

    public void fill(GroupChangesInfo groupChangesInfo) {
        openGroupChangesTab(groupChangesInfo.getTab());

        switch (groupChangesInfo.getTab()) {
            case SITE_LINK:
                fillHrefWithScheme(newSiteLink, newSitelinkschemeSelect, groupChangesInfo.getSiteLink(), false);
                takeScreenshot();
                replaceHrefButton.click();
                break;
            case LINK_PART:
                fillTextInput(linkPartFindBy, groupChangesInfo.getLinkPartFindBy());
                fillTextInput(linkPartReplaceWith, groupChangesInfo.getLinkPartReplaceWith());
                setCheckboxState(fixQuickLinks, groupChangesInfo.getFixQuickLinks());
                takeScreenshot();
                updateHrefButton.click();
                break;
            case TEXT_PART:
                fillTextInput(bodyPartFindBy, groupChangesInfo.getBodyPartFindBy());
                fillTextInput(bodyPartReplaceWith, groupChangesInfo.getBodyPartReplaceWith());
                takeScreenshot();
                updateTextButton.click();
                break;
            case QUICK_LINKS:
                getLinksPopupBlock().fillParameters(groupChangesInfo.getSiteLinks());
                clickOnClearAllLink(groupChangesInfo.getClearAllSiteLinks());
                takeScreenshot();
                addSiteLinksButton.click();
                if (groupChangesInfo.getClearAllSiteLinks() != null && groupChangesInfo.getClearAllSiteLinks()) {
                    onAlert().accept(equalTo(EditBannerResource.SITE_LINKS_WILL_BE_DELETED_ALERT_TEXT.toString()));
                }
                break;
            case DOMAIN:
                newDomain.clear();
                newDomain.sendKeys(groupChangesInfo.getDomain());
                takeScreenshot();
                updateDomainButton.click();
                break;
            case MINUS_KEYWORDS:
                minusKeywords.clear();
                minusKeywords.sendKeys(groupChangesInfo.getMinusKeywords());
                takeScreenshot();
                addMinusWordsButton.click();
                break;
        }
    }

    public void openGroupChangesTab(GroupChangesBlockTabs groupChangesBlockTabs) {
        tabs.stream()
                .filter(x -> x.getText().equals(groupChangesBlockTabs.toString()))
                .findFirst()
                .orElseThrow(() -> new DirectWebError(format("Таб %s не найден", groupChangesBlockTabs.toString())))
                .click();
    }

    public void checkSiteLinks(SiteLinkInfoWeb[] siteLinks) {
        getLinksPopupBlock().checkParameters(siteLinks);
    }

    public void clickOnClearAllLink(Boolean isClear) {
        if (isClear != null && isClear) {
            getLinksPopupBlock().clickOnClearAllLink();
            // костыль из-за бага DIRECT-84312, который всё никак не починят
            getLinksPopupBlock().clickOnClearAllLink();
        }
    }

}
