package ru.yandex.autotests.direct.web.pages.banners.blocks.edit.bem;

import java.util.List;

import org.hamcrest.Matcher;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import ru.yandex.autotests.direct.web.pages.ExtendedHtmlElement;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.JavaScriptActions;
import ru.yandex.autotests.direct.web.webelements.bem.FileInputBEM;
import ru.yandex.qatools.allure.webdriver.rules.WebDriverConfiguration;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.Button;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.matchers.WebElementMatchers;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.web.steps.CommonSteps.waitForElement;
import static ru.yandex.autotests.direct.web.util.WebElementsActions.getVisibleElement;

@FindBy(xpath = "//div[contains(@class, 'popup_visibility_visible')]" +
        "/div[contains(@class,  'popup__content')]" +
        "[.//div[contains(@class, 'b-pic-selector')]]")
public class ImagePopup1 extends ExtendedHtmlElement implements ImagePopupInterface {

    @Name("Тег с текущей картинкой")
    @FindBy(xpath = ".//img[contains(@class , 'b-pic-selector__existing')]")
    private WebElement image;

    @Name("Загрузить с компьютера")
    @FindBy(xpath = ".//button[contains(@class, 'b-pic-selector__action_type_local')]")
    private List<Button> loadFromLocal;

    @Name("Загрузить из интернета")
    @FindBy(xpath = ".//button[contains(@class, 'b-pic-selector__action_type_url')]")
    private List<Button> loadFromWWWButtons;

    @Name("Выбрать из уже загруженных")
    @FindBy(xpath = ".//button[contains(@class, 'b-pic-selector__action_type_gallery')]")
    private List<Button> loadFromGallery;

    @Name("Кнопка сохранить")
    @FindBy(xpath = ".//button[contains(@class, 'b-pic-selector__action_type_save')]")
    private Button saveButton;

    @Name("Кнопка отменить")
    @FindBy(xpath = ".//button[contains(@class, 'b-pic-selector__action_type_save')]")
    private Button cencelButton;

    @Name("Инпут для файла")
    @FindBy(xpath = ".//input[@type='file']")
    private FileInputBEM fileInput;

    @Name("Поле для ввода ссылки на картинку")
    @FindBy(xpath = ".//input[@id = 'url-input']")
    private TextInput imageUrl;

    @Name("Кнопка загрузить")
    @FindBy(xpath = ".//button[contains(@class, 'b-pic-selector__action_type_fetch-url')]")
    private Button fetchURL;

    @Name("Кнопка удалить")
    @FindBy(xpath = ".//button[contains(@class, 'b-pic-selector__action_type_remove')]")
    private Button removeImg;

    @Name("Список изображений галереи")
    @FindBy(xpath = ".//img[contains(@class , 'b-pic-selector__piclist-item-img')]")
    private List<WebElement> gallery;

    @Name("Спиннер загрузки изображения")
    @FindBy(xpath = ".//div[@class='b-pic-selector__file-loading']//img[contains(@class,'spin__icon')]")
    private WebElement loadImageSpinner;

    private WebElement getElementFromGalleryByHash(String hash) {
        for (WebElement element : gallery) {
            if (element.getAttribute("src").contains(hash)) {
                return element;
            }
        }
        throw new DirectWebError("Изображение не найдено");
    }

    @Override
    public void loadLocalImage(String imgName) {
        getVisibleElement(loadFromLocal).click();
        takeScreenshot();
        String filePath = "img/" + imgName;
        fileInput.setFileToUpload(filePath);
        waitForElement(loadImageSpinner, 5, not(WebElementMatchers.isDisplayed()));
        takeScreenshot();
        saveButton.click();
        takeScreenshot();
    }

    @Override
    public void loadImageFromInternet(String imgUrl) {
        getVisibleElement(loadFromWWWButtons).click();
        takeScreenshot();
        imageUrl.sendKeys(imgUrl);
        takeScreenshot();
        fetchURL.click();
        waitForElement(saveButton.getWrappedElement(), 5, WebElementMatchers.isEnabled());
        takeScreenshot();
        saveButton.click();
        takeScreenshot();
    }

    @Override
    public void loadImageFromGallery(String imgHash) {
        getVisibleElement(loadFromGallery).click();
        takeScreenshot();
        WebElement element = getElementFromGalleryByHash(imgHash);
        if (element != null) {
            element.click();
            takeScreenshot();
            new JavaScriptActions(config).scrollToElement(saveButton.getWrappedElement());
            saveButton.click();
        }
        takeScreenshot();
    }

    //Заглушка, метод указан в интерфейсе для другого класса
    @Override
    public void loadImageNewCreative(String imgName) {
        throw new UnsupportedOperationException();
    }

    //Заглушка, метод указан в интерфейсе для другого класса
    @Override
    public void loadImageExistingCreative(String imgName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkImage(Matcher matcher) {
        assertThat("картинка не соответствует ожиданиям", image, matcher);
    }

    @Override
    public void removeImg() {
        removeImg.click();
    }

    @Override
    public void setConfig(WebDriverConfiguration config) {
        this.config = config;
    }
}
